/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerRootDescription {
    private static final String RESOURCE_NAME = ServerRootDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle2 = ServerRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("server"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get(new String[]{"attributes", "name", "description"}).set(bundle2.getString("server.name"));
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "required"}).set(false);
        root.get(new String[]{"attributes", "name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "release-version", "description"}).set(bundle2.getString("server.release-version"));
        root.get(new String[]{"attributes", "release-version", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-version", "required"}).set(true);
        root.get(new String[]{"attributes", "release-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-version", "min-length"}).set(1);
        root.get(new String[]{"attributes", "release-codename", "description"}).set(bundle2.getString("server.release-codename"));
        root.get(new String[]{"attributes", "release-codename", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-codename", "required"}).set(true);
        root.get(new String[]{"attributes", "release-codename", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-codename", "min-length"}).set(1);
        root.get(new String[]{"attributes", "product-name", "description"}).set(bundle2.getString("server.product-name"));
        root.get(new String[]{"attributes", "product-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "product-name", "required"}).set(true);
        root.get(new String[]{"attributes", "product-name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "product-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "product-version", "description"}).set(bundle2.getString("server.product-version"));
        root.get(new String[]{"attributes", "product-version", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "product-version", "required"}).set(true);
        root.get(new String[]{"attributes", "product-version", "nillable"}).set(true);
        root.get(new String[]{"attributes", "product-version", "min-length"}).set(1);
        root.get(new String[]{"attributes", "management-major-version", "description"}).set(bundle2.getString("server.management-major-version"));
        root.get(new String[]{"attributes", "management-major-version", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "management-major-version", "required"}).set(true);
        root.get(new String[]{"attributes", "management-major-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "management-major-version", "min"}).set(1);
        root.get(new String[]{"attributes", "management-minor-version", "description"}).set(bundle2.getString("server.management-minor-version"));
        root.get(new String[]{"attributes", "management-minor-version", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "management-minor-version", "required"}).set(true);
        root.get(new String[]{"attributes", "management-minor-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "management-minor-version", "min"}).set(1);
        root.get(new String[]{"attributes", "profile-name", "description"}).set(bundle2.getString("server.profile"));
        root.get(new String[]{"attributes", "profile-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "profile-name", "required"}).set(true);
        root.get(new String[]{"attributes", "profile-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "profile-name", "head-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "profile-name", "tail-comment-allowed"}).set(true);
        root.get(new String[]{"attributes", "server-state", "description"}).set(bundle2.getString("server.state"));
        root.get(new String[]{"attributes", "server-state", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "server-state", "required"}).set(true);
        root.get(new String[]{"attributes", "server-state", "nillable"}).set(false);
        root.get(new String[]{"attributes", "server-state", "min-length"}).set(1);
        root.get(new String[]{"attributes", "process-type", "description"}).set(bundle2.getString("server.process-type"));
        root.get(new String[]{"attributes", "process-type", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "process-type", "required"}).set(true);
        root.get(new String[]{"attributes", "process-type", "nillable"}).set(false);
        root.get(new String[]{"attributes", "process-type", "min-length"}).set(1);
        root.get(new String[]{"attributes", "launch-type", "description"}).set(bundle2.getString("server.launch-type"));
        root.get(new String[]{"attributes", "launch-type", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "launch-type", "required"}).set(true);
        root.get(new String[]{"attributes", "launch-type", "nillable"}).set(false);
        root.get(new String[]{"attributes", "launch-type", "min-length"}).set(1);
        root.get(new String[]{"attributes", "launch-type", "allowed"}).add(ServerEnvironment.LaunchType.DOMAIN.toString());
        root.get(new String[]{"attributes", "launch-type", "allowed"}).add(ServerEnvironment.LaunchType.STANDALONE.toString());
        root.get(new String[]{"attributes", "launch-type", "allowed"}).add(ServerEnvironment.LaunchType.EMBEDDED.toString());
        root.get("operations");
        root.get(new String[]{"children", "extension", "description"}).set(bundle2.getString("server.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "model-description"});
        root.get(new String[]{"children", "path", "description"}).set(bundle2.getString("server.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "model-description"});
        root.get(new String[]{"children", "system-property", "description"}).set(bundle2.getString("server.system-properties"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "model-description"});
        root.get(new String[]{"children", "core-service", "description"}).set(bundle2.getString("server.core-services"));
        root.get(new String[]{"children", "core-service", "min-occurs"}).set(0);
        root.get(new String[]{"children", "core-service", "model-description"});
        root.get(new String[]{"children", "interface", "description"}).set(bundle2.getString("server.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "model-description"});
        root.get(new String[]{"children", "socket-binding-group", "description"}).set(bundle2.getString("server.socket-binding"));
        root.get(new String[]{"children", "socket-binding-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "socket-binding-group", "model-description"});
        root.get(new String[]{"children", "deployment", "description"}).set(bundle2.getString("server.deployment"));
        root.get(new String[]{"children", "deployment", "min-occurs"}).set(0);
        root.get(new String[]{"children", "deployment", "model-description"});
        root.get(new String[]{"children", "subsystem", "description"}).set(bundle2.getString("server.subsystem"));
        root.get(new String[]{"children", "subsystem", "min-occurs"}).set(0);
        root.get(new String[]{"children", "subsystem", "model-description"});
        return root;
    }

    public static ModelNode getCompositeOperationDescription(Locale locale) {
        ResourceBundle bundle2 = ServerRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("composite");
        root.get("description").set(bundle2.getString("composite"));
        root.get(new String[]{"request-properties", "steps", "type"}).set(ModelType.LIST);
        root.get(new String[]{"request-properties", "steps", "description"}).set(bundle2.getString("composite.steps"));
        root.get(new String[]{"request-properties", "steps", "required"}).set(true);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.LIST);
        root.get(new String[]{"reply-properties", "description"}).set(bundle2.getString("composite.result"));
        return root;
    }

    public static ModelNode getShutdownOperationDescription(Locale locale) {
        ResourceBundle bundle2 = ServerRootDescription.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("shutdown");
        node.get("description").set(bundle2.getString("shutdown"));
        node.get(new String[]{"request-properties", "restart", "type"}).set(ModelType.BOOLEAN);
        node.get(new String[]{"request-properties", "restart", "description"}).set(bundle2.getString("shutdown.restart"));
        node.get(new String[]{"request-properties", "restart", "default"}).set(false);
        node.get(new String[]{"request-properties", "restart", "required"}).set(false);
        node.get(new String[]{"request-properties", "restart", "nillable"}).set(true);
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    public static ModelNode getDumpServicesOperationDescription(Locale locale) {
        ResourceBundle bundle2 = ServerRootDescription.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("dump-services");
        node.get("description").set(bundle2.getString("dump-services"));
        node.get("request-properties").setEmptyObject();
        node.get(new String[]{"reply-properties", "type"}).set(ModelType.STRING);
        return node;
    }

    public static ModelNode getRestartRequiredDescription(Locale locale) {
        ResourceBundle bundle2 = ServerRootDescription.getResourceBundle(locale);
        ModelNode node = new ModelNode();
        node.get("operation-name").set("server-set-restart-required");
        node.get("description").set(bundle2.getString("restart-required"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

