/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Node;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.type.AbstractLobType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.ParameterizedType;

public class SerializableToBlobType
extends AbstractLobType
implements ParameterizedType {
    public static final String CLASS_NAME = "classname";
    private Class serializableClass;
    private SerializableType type;

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return new int[]{2004};
    }

    @Override
    public Class getReturnedClass() {
        return this.serializableClass;
    }

    @Override
    public boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.type.isEqual(x, y);
    }

    @Override
    public int getHashCode(Object x, SessionFactoryImplementor session) {
        return this.type.getHashCode(x);
    }

    @Override
    public Object get(ResultSet rs, String name) throws SQLException {
        Blob blob = rs.getBlob(name);
        if (rs.wasNull()) {
            return null;
        }
        int length = (int)blob.length();
        byte[] primaryResult = blob.getBytes(1L, length);
        return this.fromBytes(primaryResult);
    }

    private static byte[] toBytes(Object object) throws SerializationException {
        return SerializationHelper.serialize((Serializable)object);
    }

    private Object fromBytes(byte[] bytes) throws SerializationException {
        return SerializationHelper.deserialize(bytes, this.getReturnedClass().getClassLoader());
    }

    @Override
    public void set(PreparedStatement st, Object value, int index, SessionImplementor session) throws SQLException {
        if (value != null) {
            byte[] toSet = SerializableToBlobType.toBytes(value);
            if (session.getFactory().getDialect().useInputStreamToInsertBlob()) {
                st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(toSet), toSet.length);
            } else {
                st.setBlob(index, Hibernate.getLobCreator(session).createBlob(toSet));
            }
        } else {
            st.setNull(index, this.sqlTypes(null)[0]);
        }
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
        this.type.setToXMLNode(node, value, factory);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.type.toLoggableString(value, factory);
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return this.type.fromXMLNode(xml, factory);
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.type.deepCopy(value, null);
    }

    @Override
    public boolean isMutable() {
        return this.type.isMutable();
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.type.replace(original, target, session, owner, copyCache);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return this.type.toColumnNullness(value, mapping);
    }

    @Override
    public void setParameterValues(Properties parameters) {
        if (parameters != null) {
            String className = parameters.getProperty(CLASS_NAME);
            if (className == null) {
                throw new MappingException("No class name defined for type: " + SerializableToBlobType.class.getName());
            }
            try {
                this.serializableClass = ReflectHelper.classForName(className);
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Unable to load class from classname parameter", e);
            }
        }
        this.type = new SerializableType(this.serializableClass);
    }
}

