/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.async.AsyncHandlerAdd;
import org.jboss.as.logging.handlers.console.ConsoleHandlerAdd;
import org.jboss.as.logging.handlers.custom.CustomHandlerAdd;
import org.jboss.as.logging.handlers.file.FileHandlerAdd;
import org.jboss.as.logging.handlers.file.PeriodicRotatingFileHandlerAdd;
import org.jboss.as.logging.handlers.file.SizeRotatingFileHandlerAdd;
import org.jboss.as.logging.util.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public abstract class LoggerHandlerRemove
extends AbstractRemoveStepHandler {
    public static final LoggerHandlerRemove ASYNC = new LoggerHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            AsyncHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };
    public static final LoggerHandlerRemove CONSOLE = new LoggerHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            ConsoleHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };
    public static final LoggerHandlerRemove CUSTOM = new LoggerHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            CustomHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };
    public static final LoggerHandlerRemove FILE = new LoggerFileHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            FileHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };
    public static final LoggerHandlerRemove PERIODIC_ROTATING_FILE = new LoggerFileHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            PeriodicRotatingFileHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };
    public static final LoggerHandlerRemove SIZE_ROTATING_FILE = new LoggerFileHandlerRemove(){

        @Override
        protected void recoverService(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> controllers) throws OperationFailedException {
            SizeRotatingFileHandlerAdd.INSTANCE.performRuntime(context, operation, model, verificationHandler, controllers);
        }
    };

    protected final void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        LoggerHandlerRemove.checkHandler(context, name);
        ServiceName serviceName = LogServices.handlerName(name);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(serviceName);
        ((Handler)controller.getValue()).close();
        context.removeService(serviceName);
        this.removeAdditionalServices(context, name);
    }

    protected final void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ArrayList controllers = new ArrayList();
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        this.recoverService(context, operation, model, verificationHandler, controllers);
    }

    protected abstract void recoverService(OperationContext var1, ModelNode var2, ModelNode var3, ServiceVerificationHandler var4, List<ServiceController<?>> var5) throws OperationFailedException;

    protected void removeAdditionalServices(OperationContext context, String name) {
    }

    static void checkHandler(OperationContext context, String handlerName) throws OperationFailedException {
        Resource root = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"logging")}));
        ModelNode subsystem = Resource.Tools.readModel((Resource)root);
        ArrayList<String> attached = new ArrayList<String>();
        ModelNode rootLogger = subsystem.get(new String[]{"root-logger", "ROOT"});
        if (rootLogger.isDefined() && rootLogger.hasDefined(CommonAttributes.HANDLERS.getName())) {
            ModelNode handlers = rootLogger.get(CommonAttributes.HANDLERS.getName());
            for (ModelNode handler : handlers.asList()) {
                if (!handlerName.equals(handler.asString())) continue;
                attached.add("ROOT");
            }
        }
        ModelNode loggers = subsystem.get("logger");
        for (Property logger2 : loggers.asPropertyList()) {
            if (!logger2.getValue().hasDefined(CommonAttributes.HANDLERS.getName())) continue;
            ModelNode handlers = logger2.getValue().get(CommonAttributes.HANDLERS.getName());
            for (ModelNode handler : handlers.asList()) {
                if (!handlerName.equals(handler.asString())) continue;
                attached.add(logger2.getName());
            }
        }
        if (!attached.isEmpty()) {
            throw new OperationFailedException(LoggingMessages.MESSAGES.handlerAttachedToLoggers(handlerName, attached));
        }
        ModelNode asyncHandlers = subsystem.get("async-handler");
        for (Property asyncHandler : asyncHandlers.asPropertyList()) {
            if (!asyncHandler.getValue().hasDefined(CommonAttributes.SUBHANDLERS.getName())) continue;
            ModelNode subhandlers = asyncHandler.getValue().get(CommonAttributes.SUBHANDLERS.getName());
            for (ModelNode handler : subhandlers.asList()) {
                if (!handlerName.equals(handler.asString())) continue;
                attached.add(asyncHandler.getName());
            }
        }
        if (!attached.isEmpty()) {
            throw new OperationFailedException(LoggingMessages.MESSAGES.handlerAttachedToHandlers(handlerName, attached));
        }
    }

    private static abstract class LoggerFileHandlerRemove
    extends LoggerHandlerRemove {
        private LoggerFileHandlerRemove() {
        }

        @Override
        protected void removeAdditionalServices(OperationContext context, String name) {
            context.removeService(LogServices.handlerFileName(name));
        }
    }
}

