/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectOutputStream;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.river.RiverMarshaller;
import org.jboss.marshalling.river.RiverPutField;
import org.jboss.marshalling.util.BooleanFieldPutter;
import org.jboss.marshalling.util.ByteFieldPutter;
import org.jboss.marshalling.util.CharFieldPutter;
import org.jboss.marshalling.util.DoubleFieldPutter;
import org.jboss.marshalling.util.FieldPutter;
import org.jboss.marshalling.util.FloatFieldPutter;
import org.jboss.marshalling.util.IntFieldPutter;
import org.jboss.marshalling.util.LongFieldPutter;
import org.jboss.marshalling.util.ObjectFieldPutter;
import org.jboss.marshalling.util.ShortFieldPutter;

public class RiverObjectOutputStream
extends MarshallerObjectOutputStream {
    private final AtomicReference<State> state = new AtomicReference<State>(State.OFF);
    private final RiverMarshaller marshaller;
    private final Marshaller delegateMarshaller;
    private RiverPutField putField;
    private SerializableClass serializableClass;
    private Object current;

    protected RiverObjectOutputStream(Marshaller delegateMarshaller, RiverMarshaller marshaller) throws IOException, SecurityException {
        super(delegateMarshaller);
        this.marshaller = marshaller;
        this.delegateMarshaller = delegateMarshaller;
    }

    public void writeFields() throws IOException {
        RiverPutField putField = this.putField;
        if (putField == null) {
            throw new NotActiveException("no current PutField object");
        }
        if (!this.state.compareAndSet(State.UNWRITTEN_FIELDS, State.ON)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        this.putField = null;
        putField.write((Marshaller)this.marshaller);
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.state.get() == State.OFF) {
            throw new NotActiveException("No object is currently being serialized");
        }
        if (this.putField == null) {
            SerializableField[] serializableFields = this.serializableClass.getFields();
            int cnt = serializableFields.length;
            FieldPutter[] fields = new FieldPutter[cnt];
            String[] names = new String[cnt];
            block11: for (int i = 0; i < cnt; ++i) {
                SerializableField field = serializableFields[i];
                names[i] = field.getName();
                switch (field.getKind()) {
                    case BOOLEAN: {
                        fields[i] = new BooleanFieldPutter();
                        continue block11;
                    }
                    case BYTE: {
                        fields[i] = new ByteFieldPutter();
                        continue block11;
                    }
                    case CHAR: {
                        fields[i] = new CharFieldPutter();
                        continue block11;
                    }
                    case DOUBLE: {
                        fields[i] = new DoubleFieldPutter();
                        continue block11;
                    }
                    case FLOAT: {
                        fields[i] = new FloatFieldPutter();
                        continue block11;
                    }
                    case INT: {
                        fields[i] = new IntFieldPutter();
                        continue block11;
                    }
                    case LONG: {
                        fields[i] = new LongFieldPutter();
                        continue block11;
                    }
                    case OBJECT: {
                        fields[i] = new ObjectFieldPutter(field.isUnshared());
                        continue block11;
                    }
                    case SHORT: {
                        fields[i] = new ShortFieldPutter();
                    }
                }
            }
            this.putField = new RiverPutField(fields, names);
        }
        return this.putField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerializableClass swapClass(SerializableClass newSerializableClass) {
        try {
            SerializableClass serializableClass = this.serializableClass;
            return serializableClass;
        }
        finally {
            this.serializableClass = newSerializableClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object swapCurrent(Object current) {
        try {
            Object object = this.current;
            return object;
        }
        finally {
            this.current = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defaultWriteObject() throws IOException {
        if (!this.state.compareAndSet(State.UNWRITTEN_FIELDS, State.ON)) {
            throw new NotActiveException("writeFields() may only be called when the fields have not yet been written");
        }
        try {
            this.marshaller.doWriteFields(this.serializableClass, this.current);
        }
        finally {
            this.putField = null;
            this.serializableClass = null;
            this.current = null;
        }
    }

    protected State start() throws IOException {
        return this.state.getAndSet(State.UNWRITTEN_FIELDS);
    }

    protected void finish(State restoreState) throws IOException {
        switch (this.state.getAndSet(restoreState)) {
            case UNWRITTEN_FIELDS: {
                if (this.serializableClass.getFields().length <= 0) break;
                throw new NotActiveException("Fields were never written");
            }
        }
    }

    protected void fullReset() {
        this.state.set(State.OFF);
        this.putField = null;
        this.serializableClass = null;
        this.current = null;
    }

    private void checkState() throws NotActiveException {
        switch (this.state.get()) {
            case OFF: {
                throw new NotActiveException("Object stream not active");
            }
            case ON: {
                return;
            }
            case UNWRITTEN_FIELDS: {
                throw new NotActiveException("Fields not yet written");
            }
        }
        throw new IllegalStateException("Unknown state");
    }

    protected static enum State {
        OFF,
        UNWRITTEN_FIELDS,
        ON;

    }
}

