/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.BaseEnversEventListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.ModWorkUnit;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;

public class EnversPostUpdateEventListenerImpl
extends BaseEnversEventListener
implements PostUpdateEventListener {
    protected EnversPostUpdateEventListenerImpl(AuditConfiguration enversConfiguration) {
        super(enversConfiguration);
    }

    public void onPostUpdate(PostUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getAuditConfiguration().getEntCfg().isVersioned(entityName)) {
            AuditProcess auditProcess = this.getAuditConfiguration().getSyncManager().get(event.getSession());
            ModWorkUnit workUnit = new ModWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getAuditConfiguration(), event.getId(), event.getPersister(), event.getState(), event.getOldState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, event.getState(), event.getOldState(), (SessionImplementor)event.getSession());
            }
        }
    }
}

