/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.PropertyMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.AuditEntity;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.reflection.ReflectionTools;
import org.hibernate.property.Setter;

public class OneToOneNotOwningMapper
implements PropertyMapper {
    private String owningReferencePropertyName;
    private String owningEntityName;
    private PropertyData propertyData;

    public OneToOneNotOwningMapper(String owningReferencePropertyName, String owningEntityName, PropertyData propertyData) {
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.owningEntityName = owningEntityName;
        this.propertyData = propertyData;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object value;
        if (obj == null) {
            return;
        }
        EntityConfiguration entCfg = verCfg.getEntCfg().get(this.owningEntityName);
        if (entCfg == null) {
            entCfg = verCfg.getEntCfg().getNotVersionEntityConfiguration(this.owningEntityName);
        }
        Class<?> entityClass = ReflectionTools.loadClass(entCfg.getEntityClassName());
        try {
            value = versionsReader.createQuery().forEntitiesAtRevision(entityClass, this.owningEntityName, revision).add(AuditEntity.relatedId(this.owningReferencePropertyName).eq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            value = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException("Many versions results for one-to-one relationship: (" + this.owningEntityName + ", " + this.owningReferencePropertyName + ")");
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyData);
        setter.set(obj, value, null);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

