/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.transport.wrapper;

import java.rmi.Remote;
import java.util.HashMap;
import org.apache.juddi.v3.client.ClassUtil;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.wrapper.Handler;
import org.apache.juddi.v3.client.transport.wrapper.RequestHandler;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DeleteBusiness;
import org.uddi.api_v3.DeletePublisherAssertions;
import org.uddi.api_v3.DeleteService;
import org.uddi.api_v3.DeleteTModel;
import org.uddi.api_v3.GetAssertionStatusReport;
import org.uddi.api_v3.GetPublisherAssertions;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.SaveBinding;
import org.uddi.api_v3.SaveBusiness;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SaveTModel;
import org.uddi.api_v3.SetPublisherAssertions;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UDDIPublicationService {
    private static final String DEFAULT_NODE_NAME = "default";
    private String managerName = System.getProperty("org.apache.juddi.v3.client.manager.name");
    private String nodeName = System.getProperty("org.apache.juddi.v3.client.node.name", "default");
    private HashMap<String, Handler> operations = new HashMap();

    public UDDIPublicationService() {
        this.operations.put("get_registeredInfo", new Handler("getRegisteredInfo", GetRegisteredInfo.class));
        this.operations.put("save_business", new Handler("saveBusiness", SaveBusiness.class));
        this.operations.put("save_service", new Handler("saveService", SaveService.class));
        this.operations.put("save_binding", new Handler("saveBinding", SaveBinding.class));
        this.operations.put("save_tModel", new Handler("saveTModel", SaveTModel.class));
        this.operations.put("delete_business", new Handler("deleteBusiness", DeleteBusiness.class));
        this.operations.put("delete_service", new Handler("deleteService", DeleteService.class));
        this.operations.put("delete_binding", new Handler("deleteBinding", DeleteBinding.class));
        this.operations.put("delete_tModel", new Handler("deleteTModel", DeleteTModel.class));
        this.operations.put("add_publisherAssertions", new Handler("addPublisherAssertions", AddPublisherAssertions.class));
        this.operations.put("set_publisherAssertions", new Handler("setPublisherAssertions", SetPublisherAssertions.class));
        this.operations.put("get_publisherAssertions", new Handler("getPublisherAssertions", GetPublisherAssertions.class));
        this.operations.put("delete_publisherAssertions", new Handler("deletePublisherAssertions", DeletePublisherAssertions.class));
        this.operations.put("get_assertionStatusReport", new Handler("getAssertionStatusReport", GetAssertionStatusReport.class));
    }

    public void validateRequest(String operation) throws UnsupportedOperationException {
        if (operation == null || operation.trim().length() == 0) {
            throw new UnsupportedOperationException("operation " + operation + " not supported");
        }
    }

    public Node publish(Element uddiReq) throws Exception {
        return this.publish(uddiReq, this.nodeName, this.managerName);
    }

    public Node publish(Element uddiReq, String nodeName, String managerName) throws Exception {
        UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager(managerName);
        String clazz = manager.getClientConfig().getUDDINode(nodeName).getProxyTransport();
        Class<?> transportClass = ClassUtil.forName(clazz, this.getClass());
        Transport transport = (Transport)transportClass.getConstructor(String.class, String.class).newInstance(managerName, nodeName);
        UDDIPublicationPortType publish = transport.getUDDIPublishService();
        RequestHandler requestHandler = new RequestHandler();
        requestHandler.setPortType((Remote)publish);
        String operation = requestHandler.getOperation(uddiReq);
        Handler opHandler = this.operations.get(operation);
        if (opHandler == null) {
            throw new IllegalArgumentException("Operation not found : " + operation);
        }
        requestHandler.setMethodName(opHandler.getMethodName());
        requestHandler.setOperationClass(opHandler.getParameter());
        String version = requestHandler.getVersion(uddiReq, operation);
        this.validateRequest(operation);
        Node temp = requestHandler.invoke(uddiReq);
        return temp;
    }
}

