/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.security.authentication;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.security.wss4j.AbstractUsernameTokenAuthenticatingInterceptor;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreator;
import org.jboss.wsf.stack.cxf.security.nonce.NonceStore;

public class SubjectCreatingInterceptor
extends AbstractUsernameTokenAuthenticatingInterceptor {
    private ThreadLocal<SecurityDomainContext> sdc = new ThreadLocal();
    private SubjectCreator helper = new SubjectCreator();

    public SubjectCreatingInterceptor() {
        this(new HashMap<String, Object>());
    }

    public SubjectCreatingInterceptor(Map<String, Object> properties) {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage msg) throws Fault {
        Endpoint ep = (Endpoint)msg.getExchange().get(Endpoint.class);
        this.sdc.set(ep.getSecurityDomainContext());
        try {
            super.handleMessage(msg);
        }
        finally {
            if (this.sdc != null) {
                this.sdc.remove();
            }
        }
    }

    public Subject createSubject(String name, String password, boolean isDigest, String nonce, String created) {
        return this.helper.createSubject(this.sdc.get(), name, password, isDigest, nonce, created);
    }

    public void setPropagateContext(boolean propagateContext) {
        this.helper.setPropagateContext(propagateContext);
    }

    public void setTimestampThreshold(int timestampThreshold) {
        this.helper.setTimestampThreshold(timestampThreshold);
    }

    public void setNonceStore(NonceStore nonceStore) {
        this.helper.setNonceStore(nonceStore);
    }

    public void setDecodeNonce(boolean decodeNonce) {
        this.helper.setDecodeNonce(decodeNonce);
    }
}

