/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.keygen;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCSQLServerCreateCommand
extends JDBCIdentityColumnCreateCommand {
    @Override
    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) {
        super.initEntityCommand(entityCommand);
        this.pkSQL = entityCommand.getAttribute("pk-sql");
        if (this.pkSQL == null) {
            this.pkSQL = "SELECT SCOPE_IDENTITY()";
        }
    }

    @Override
    protected void initInsertSQL() {
        super.initInsertSQL();
        this.insertSQL = this.insertSQL + "; " + this.pkSQL;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int executeInsert(int index, PreparedStatement ps, CmpEntityBeanContext ctx) throws SQLException {
        int n;
        ps.execute();
        ResultSet rs = null;
        try {
            int rows = ps.getUpdateCount();
            if (rows != 1) {
                throw CmpMessages.MESSAGES.expectedSingleRowButReceivedMore(rows);
            }
            if (!ps.getMoreResults()) {
                throw CmpMessages.MESSAGES.expectedResultSetReceivedUpdateCount();
            }
            rs = ps.getResultSet();
            if (!rs.next()) {
                throw CmpMessages.MESSAGES.getGeneratedKeysEmptyResultSet();
            }
            this.pkField.loadInstanceResults(rs, 1, ctx);
            n = rows;
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw CmpMessages.MESSAGES.errorExtractingGeneratedKey(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        return n;
    }
}

