/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.tomcat.util.Constants;

public class StandardManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener {
    public static final int MAX_ACTIVE_SESSIONS = Integer.valueOf(System.getProperty("org.apache.catalina.session.StandardManager.MAX_ACTIVE_SESSIONS", Constants.LOW_MEMORY ? "1024" : "-1"));
    public static final String PATHNAME = System.getProperty("org.apache.catalina.session.StandardManager.PATHNAME");
    protected static final String info = "StandardManager/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected int maxActiveSessions = MAX_ACTIVE_SESSIONS;
    protected static String name = "StandardManager";
    protected String pathname = PATHNAME;
    protected boolean started = false;
    protected int rejectedSessions = 0;
    protected long processingTime = 0L;

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    @Override
    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    @Override
    public String getName() {
        return name;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        String oldPathname = this.pathname;
        this.pathname = pathname;
        this.support.firePropertyChange("pathname", oldPathname, this.pathname);
    }

    @Override
    public Session createSession(String sessionId, Random random) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        return super.createSession(sessionId, random);
    }

    @Override
    public void load() throws ClassNotFoundException, IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoLoad());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unreported exception in load() " + exception));
                }
            }
        } else {
            this.doLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoad() throws ClassNotFoundException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Start: Loading persisted sessions");
        }
        this.sessions.clear();
        File file = this.file();
        if (file == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.loading", this.pathname));
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        try {
            fis = new FileInputStream(file.getAbsolutePath());
            BufferedInputStream bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Creating custom object input stream for class loader ");
                }
                ois = new CustomObjectInputStream(bis, classLoader);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Creating standard object input stream");
                }
                ois = new ObjectInputStream(bis);
            }
        }
        catch (FileNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No persisted data file found");
            }
            return;
        }
        catch (IOException e) {
            this.log.error((Object)sm.getString("standardManager.loading.ioe", e), (Throwable)e);
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                ois = null;
            }
            throw e;
        }
        Map map = this.sessions;
        synchronized (map) {
            try {
                Integer count = (Integer)ois.readObject();
                int n = count;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading " + n + " persisted sessions"));
                }
                for (int i = 0; i < n; ++i) {
                    StandardSession session = this.getNewSession();
                    session.readObjectData(ois);
                    session.setManager(this);
                    if (!session.isValidInternal()) continue;
                    this.sessions.put(session.getIdInternal(), session);
                    session.activate();
                    ++this.sessionCounter;
                }
            }
            catch (ClassNotFoundException e) {
                this.log.error((Object)sm.getString("standardManager.loading.cnfe", e), (Throwable)e);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    ois = null;
                }
                throw e;
            }
            catch (IOException e) {
                this.log.error((Object)sm.getString("standardManager.loading.ioe", e), (Throwable)e);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    ois = null;
                }
                throw e;
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException f) {}
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Finish: Loading persisted sessions");
        }
    }

    @Override
    public void unload() throws IOException {
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                AccessController.doPrivileged(new PrivilegedDoUnload());
            }
            catch (PrivilegedActionException ex) {
                Exception exception = ex.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unreported exception in unLoad() " + exception));
                }
            }
        } else {
            this.doUnload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnload() throws IOException {
        File file;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unloading persisted sessions");
        }
        if ((file = this.file()) == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("standardManager.unloading", this.pathname));
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
        }
        catch (IOException e) {
            this.log.error((Object)sm.getString("standardManager.unloading.ioe", e), (Throwable)e);
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                oos = null;
            }
            throw e;
        }
        ArrayList<StandardSession> list = new ArrayList<StandardSession>();
        Map f = this.sessions;
        synchronized (f) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unloading " + this.sessions.size() + " sessions"));
            }
            try {
                oos.writeObject(new Integer(this.sessions.size()));
                for (StandardSession session : this.sessions.values()) {
                    list.add(session);
                    session.passivate();
                    session.writeObjectData(oos);
                }
            }
            catch (IOException e) {
                this.log.error((Object)sm.getString("standardManager.unloading.ioe", e), (Throwable)e);
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException f2) {
                        // empty catch block
                    }
                    oos = null;
                }
                throw e;
            }
        }
        try {
            oos.flush();
            oos.close();
            oos = null;
        }
        catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException f3) {
                    // empty catch block
                }
                oos = null;
            }
            throw e;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Expiring " + list.size() + " persisted sessions"));
        }
        for (StandardSession session : list) {
            try {
                session.expire(false);
            }
            catch (Throwable t) {}
            continue;
            finally {
                session.recycle();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Unloading complete");
        }
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        try {
            this.load();
        }
        catch (Throwable t) {
            this.log.error((Object)sm.getString("standardManager.managerLoad"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            this.unload();
        }
        catch (Throwable t) {
            this.log.error((Object)sm.getString("standardManager.managerUnload"), t);
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            Session session = sessions[i];
            try {
                if (!session.isValid()) continue;
                session.expire();
                continue;
            }
            catch (Throwable t) {
                continue;
            }
            finally {
                session.recycle();
            }
        }
        if (this.initialized) {
            this.destroy();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)sm.getString("standardManager.sessionTimeout", event.getNewValue().toString()));
            }
        }
    }

    protected File file() {
        ServletContext servletContext;
        File tempdir;
        if (this.pathname == null || this.pathname.length() == 0) {
            return null;
        }
        File file = new File(this.pathname);
        if (!file.isAbsolute() && this.container instanceof Context && (tempdir = (File)(servletContext = ((Context)this.container).getServletContext()).getAttribute("javax.servlet.context.tempdir")) != null) {
            file = new File(tempdir, this.pathname);
        }
        return file;
    }

    private class PrivilegedDoUnload
    implements PrivilegedExceptionAction {
        PrivilegedDoUnload() {
        }

        public Object run() throws Exception {
            StandardManager.this.doUnload();
            return null;
        }
    }

    private class PrivilegedDoLoad
    implements PrivilegedExceptionAction {
        PrivilegedDoLoad() {
        }

        public Object run() throws Exception {
            StandardManager.this.doLoad();
            return null;
        }
    }
}

