/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgroups.Address;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Promise;

public class AckCollector {
    private final List<Object> missing_acks;
    private final Promise<Boolean> all_acks_received = new Promise();
    private final Set<Address> suspected_mbrs = new HashSet<Address>();
    private int expected_acks = 0;

    public AckCollector() {
        this.missing_acks = new ArrayList<Object>();
        this.expected_acks = 0;
    }

    public AckCollector(ViewId v, List<Object> l) {
        this.missing_acks = new ArrayList<Object>(l);
        if (v != null) {
            this.expected_acks = l != null ? l.size() : 0;
        }
    }

    public synchronized String printMissing() {
        return this.missing_acks.toString();
    }

    public synchronized String printSuspected() {
        return this.suspected_mbrs.toString();
    }

    public synchronized void reset(Collection<Address> members) {
        this.suspected_mbrs.clear();
        this.missing_acks.clear();
        if (members != null && !members.isEmpty()) {
            this.missing_acks.addAll(members);
            this.expected_acks = members.size();
        }
        this.missing_acks.removeAll(this.suspected_mbrs);
        this.all_acks_received.reset();
    }

    public synchronized int size() {
        return this.missing_acks.size();
    }

    public synchronized int expectedAcks() {
        return this.expected_acks;
    }

    public synchronized void ack(Object member) {
        this.missing_acks.remove(member);
        if (this.missing_acks.isEmpty()) {
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public synchronized void suspect(Address member) {
        this.ack(member);
        this.suspected_mbrs.add(member);
    }

    public synchronized void unsuspect(Address member) {
        this.suspected_mbrs.remove(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleView(View v) {
        if (v == null) {
            return;
        }
        List<Address> mbrs = v.getMembers();
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.retainAll(mbrs);
        }
    }

    public boolean waitForAllAcks() {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResult();
        return result != null && result instanceof Boolean && result != false;
    }

    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result instanceof Boolean && result != false;
    }

    public String toString() {
        return "missing=" + this.printMissing();
    }
}

