/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;

public class SessionObjectReferenceImpl
implements SessionObjectReference {
    private final Map<String, ServiceName> viewServices;
    private final String ejbName;

    public SessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.ejbName = descriptor.getEjbName();
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (Map.Entry<Class<?>, ServiceName> entry : descriptor.getViewServices().entrySet()) {
            Class<?> viewClass = entry.getKey();
            if (viewClass == null) continue;
            HashSet<Class> seen = new HashSet<Class>();
            HashSet toProcess = new HashSet();
            toProcess.add(viewClass);
            while (!toProcess.isEmpty()) {
                Iterator it = toProcess.iterator();
                Class clazz = (Class)it.next();
                it.remove();
                seen.add(clazz);
                viewServices.put(clazz.getName(), entry.getValue());
                Class superclass = clazz.getSuperclass();
                if (superclass != Object.class && superclass != null && !seen.contains(superclass)) {
                    toProcess.add(superclass);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (seen.contains(iface)) continue;
                    toProcess.add(iface);
                }
            }
        }
        this.viewServices = viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.viewServices.containsKey(businessInterfaceType.getName())) {
            ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            try {
                return (S)view.createInstance().getInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw WeldMessages.MESSAGES.viewNotFoundOnEJB(businessInterfaceType.getName(), this.ejbName);
    }

    public void remove() {
    }

    public boolean isRemoved() {
        return false;
    }
}

