/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.dmr.ModelNode;

public class BatchRunHandler
extends CommandHandlerWithHelp {
    public BatchRunHandler() {
        super("batch-run", true);
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            throw new CommandFormatException("No active batch.");
        }
        Batch batch = batchManager.getActiveBatch();
        List<BatchedCommand> currentBatch = batch.getCommands();
        if (currentBatch.isEmpty()) {
            batchManager.discardActiveBatch();
            throw new CommandFormatException("The batch is empty.");
        }
        ModelNode composite = batch.toRequest();
        try {
            result = ctx.getModelControllerClient().execute(composite);
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to execute batch: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess(result)) {
            throw new CommandFormatException("Failed to execute batch: " + Util.getFailureDescription(result));
        }
        batchManager.discardActiveBatch();
        ctx.printLine("The batch executed successfully.");
    }
}

