/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jsapi;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.jsapi.JSAPIWriter;
import org.jboss.resteasy.jsapi.ServiceRegistry;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JSAPIServlet
extends HttpServlet {
    private static final long serialVersionUID = -1985015444704126795L;
    private static final Logger logger = Logger.getLogger(JSAPIServlet.class);
    private ServiceRegistry service;
    private JSAPIWriter apiWriter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (logger.isDebugEnabled()) {
            logger.info("Loading JSAPI Servlet");
        }
        this.scanResources();
        if (logger.isDebugEnabled()) {
            logger.debug("JSAPIServlet loaded");
        }
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        if (logger.isDebugEnabled()) {
            logger.debug("Serving " + pathInfo);
            logger.debug("Query " + req.getQueryString());
        }
        PrintWriter printWriter = resp.getWriter();
        this.apiWriter.writeJavaScript(uri, printWriter, this.service);
    }

    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        ResourceMethodRegistry registry = (ResourceMethodRegistry)servletContext.getAttribute(Registry.class.getName());
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)servletContext.getAttribute(ResteasyProviderFactory.class.getName());
        String restPath = servletContext.getInitParameter("resteasy.servlet.mapping.prefix");
        this.service = new ServiceRegistry(null, registry, providerFactory, null);
        this.apiWriter = new JSAPIWriter(restPath);
    }
}

