/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.BaseAuthenticationInfo;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.ApplicationPolicyRegistration;
import org.jboss.security.config.SecurityConfiguration;

public class StandaloneConfiguration
extends Configuration
implements ApplicationPolicyRegistration {
    protected static Logger log = Logger.getLogger(StandaloneConfiguration.class);
    protected Configuration parentConfig;
    protected ConcurrentMap<String, ApplicationPolicy> appPolicyMap = new ConcurrentHashMap<String, ApplicationPolicy>();
    protected static StandaloneConfiguration _instance;

    protected StandaloneConfiguration() {
    }

    public static StandaloneConfiguration getInstance() {
        if (_instance == null) {
            _instance = new StandaloneConfiguration();
        }
        return _instance;
    }

    public void addApplicationPolicy(String appName, ApplicationPolicy aPolicy) {
        this.appPolicyMap.put(appName, aPolicy);
        SecurityConfiguration.addApplicationPolicy(aPolicy);
    }

    public ApplicationPolicy getApplicationPolicy(String domainName) {
        return (ApplicationPolicy)this.appPolicyMap.get(domainName);
    }

    public boolean removeApplicationPolicy(String domainName) {
        ApplicationPolicy ap = (ApplicationPolicy)this.appPolicyMap.remove(domainName);
        return ap != null;
    }

    public void setParentConfig(Configuration parentConfig) {
        this.parentConfig = parentConfig;
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        AppConfigurationEntry[] entry = null;
        ApplicationPolicy aPolicy = this.getApplicationPolicy(appName);
        BaseAuthenticationInfo authInfo = null;
        if (aPolicy != null) {
            authInfo = aPolicy.getAuthenticationInfo();
        }
        if (authInfo == null) {
            ApplicationPolicy defPolicy;
            if (log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in appConfigs, tyring parentCont: " + this.parentConfig));
            }
            if (this.parentConfig != null) {
                entry = this.parentConfig.getAppConfigurationEntry(appName);
            }
            if (entry == null && log.isTraceEnabled()) {
                log.trace((Object)("getAppConfigurationEntry(" + appName + "), no entry in parentConfig, trying: " + "other"));
            }
            BaseAuthenticationInfo baseAuthenticationInfo = authInfo = (defPolicy = this.getApplicationPolicy("other")) != null ? (AuthenticationInfo)defPolicy.getAuthenticationInfo() : null;
        }
        if (authInfo != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("End getAppConfigurationEntry(" + appName + "), authInfo=" + authInfo));
            }
            final BaseAuthenticationInfo theAuthInfo = authInfo;
            PrivilegedAction<AppConfigurationEntry[]> action = new PrivilegedAction<AppConfigurationEntry[]>(){

                @Override
                public AppConfigurationEntry[] run() {
                    return theAuthInfo.copyAppConfigurationEntry();
                }
            };
            entry = AccessController.doPrivileged(action);
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("End getAppConfigurationEntry(" + appName + "), failed to find entry"));
        }
        return entry;
    }
}

