/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb.client.remoting.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.HandleableCloseable;

class AutoConnectionCloser
implements Runnable {
    private static Logger logger = Logger.getLogger(AutoConnectionCloser.class);
    static final AutoConnectionCloser INSTANCE = new AutoConnectionCloser();
    private final List<Connection> connections = new ArrayList<Connection>();
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    private AutoConnectionCloser() {
        SecurityActions.addShutdownHook(new Thread(this));
    }

    @Override
    public void run() {
        this.closeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        List<Endpoint> list = this.endpoints;
        synchronized (list) {
            this.endpoints.add(endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAll() {
        List<HandleableCloseable<Connection>> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                this.safeClose(connection);
            }
        }
        list = this.endpoints;
        synchronized (list) {
            for (Endpoint endpoint : this.endpoints) {
                this.safeClose(endpoint);
            }
        }
    }

    private void safeClose(Closeable closable) {
        try {
            logger.debug("Closing " + closable);
            closable.close();
        }
        catch (Throwable e) {
            logger.debug((Object)("Exception closing " + closable), e);
        }
    }
}

