/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.repository.ArtifactProviderPlugin;
import org.jboss.osgi.repository.RepositoryCachePlugin;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.service.repository.Repository;

public final class RepositoryImpl
implements Repository {
    private static Logger log = Logger.getLogger(RepositoryImpl.class);
    private final ArtifactProviderPlugin provider;
    private final RepositoryCachePlugin cache;

    public RepositoryImpl(ArtifactProviderPlugin provider, RepositoryCachePlugin cache) {
        this.provider = provider;
        this.cache = cache;
    }

    public Collection<Capability> findProviders(Requirement req) {
        log.infof("find providers for: %s", (Object)req);
        Collection caps = this.cache.findProviders(req);
        if (caps.isEmpty()) {
            caps = this.provider.findProviders(req);
            caps = this.cache.storeCapabilities(caps);
        }
        log.infof("found matching caps: %s", (Object)caps);
        return Collections.unmodifiableCollection(caps);
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> reqs) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : reqs) {
            Collection<Capability> caps = this.findProviders(requirement);
            result.put(requirement, caps);
        }
        return Collections.unmodifiableMap(result);
    }
}

