/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.ee;

import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.jboss.JBossPortComponentRef;
import org.jboss.metadata.javaee.jboss.StubPropertyMetaData;
import org.jboss.metadata.parser.ee.AddressingParser;
import org.jboss.metadata.parser.ee.Attribute;
import org.jboss.metadata.parser.ee.Element;
import org.jboss.metadata.parser.ee.RespectBindingParser;
import org.jboss.metadata.parser.ee.StubPropertyParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class PortComponentRefParser
extends MetaDataElementParser {
    public static JBossPortComponentRef parse(XMLStreamReader reader) throws XMLStreamException {
        JBossPortComponentRef portComponentRef = new JBossPortComponentRef();
        int count = reader.getAttributeCount();
        block15: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (PortComponentRefParser.attributeHasNamespace(reader, i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    portComponentRef.setId(value);
                    continue block15;
                }
                default: {
                    throw PortComponentRefParser.unexpectedAttribute(reader, i);
                }
            }
        }
        LinkedList<StubPropertyMetaData> stubProperties = new LinkedList<StubPropertyMetaData>();
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SERVICE_ENDPOINT_INTERFACE: {
                    portComponentRef.setServiceEndpointInterface(PortComponentRefParser.getElementText(reader));
                    continue block16;
                }
                case ENABLE_MTOM: {
                    portComponentRef.setEnableMtom(Boolean.valueOf(PortComponentRefParser.getElementText(reader)));
                    continue block16;
                }
                case MTOM_THRESHOLD: {
                    portComponentRef.setMtomThreshold(Integer.valueOf(PortComponentRefParser.getElementText(reader)));
                    continue block16;
                }
                case ADDRESSING: {
                    portComponentRef.setAddressing(AddressingParser.parse(reader));
                    continue block16;
                }
                case RESPECT_BINDING: {
                    portComponentRef.setRespectBinding(RespectBindingParser.parse(reader));
                    continue block16;
                }
                case PORT_COMPONENT_LINK: {
                    portComponentRef.setPortComponentLink(PortComponentRefParser.getElementText(reader));
                    continue block16;
                }
                case CONFIG_NAME: {
                    portComponentRef.setConfigName(PortComponentRefParser.getElementText(reader));
                    continue block16;
                }
                case CONFIG_FILE: {
                    portComponentRef.setConfigFile(PortComponentRefParser.getElementText(reader));
                    continue block16;
                }
                case PORT_QNAME: {
                    portComponentRef.setPortQname(PortComponentRefParser.parseQName(reader, PortComponentRefParser.getElementText(reader)));
                    continue block16;
                }
                case STUB_PROPERTY: {
                    stubProperties.add(StubPropertyParser.parse(reader));
                    continue block16;
                }
            }
            throw PortComponentRefParser.unexpectedElement(reader);
        }
        if (stubProperties.size() > 0) {
            portComponentRef.setStubProperties(stubProperties);
        }
        return portComponentRef;
    }
}

