/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.jboss.ws.common.utils.NullPrintStream;
import org.xml.sax.EntityResolver;

public class SunRIConsumerImpl
extends WSContractConsumer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SunRIConsumerImpl.class);
    private List<File> bindingFiles;
    private File catalog;
    private boolean extension;
    private boolean generateSource;
    private boolean nocompile;
    private File outputDir = new File("output");
    private File sourceDir;
    private String targetPackage;
    private PrintStream messageStream;
    private String wsdlLocation;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void consume(URL wsdl) {
        String xmlInputFactory;
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.extension) {
            args.add("-extension");
        }
        if (this.additionalHeaders) {
            args.add("-XadditionalHeaders");
        }
        if (this.nocompile) {
            args.add("-Xnocompile");
        }
        if (this.generateSource) {
            args.add("-keep");
            if (this.sourceDir != null) {
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_CREATE_DIRECTORY", (Object[])new Object[]{this.sourceDir.getName()}));
                }
                args.add("-s");
                args.add(this.sourceDir.getAbsolutePath());
            }
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
            args.add("-Xdebug");
        } else {
            stream = NullPrintStream.getInstance();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_CREATE_DIRECTORY", (Object[])new Object[]{this.outputDir.getName()}));
        }
        args.add("-d");
        args.add(this.outputDir.getAbsolutePath());
        if (this.target != null) {
            if (!(this.target.equals("2.0") || this.target.equals("2.1") || this.target.equals("2.2"))) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"WSCONSUME_JAXWS21_22", (Object[])new Object[0]));
            }
            args.add("-target");
            args.add(this.target);
        }
        args.add(wsdl.toString());
        String javaClassPath = System.getProperty("java.class.path");
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuilder javaCP = new StringBuilder();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        if ((xmlInputFactory = System.getProperty("javax.xml.stream.XMLInputFactory")) == null) {
            System.setProperty("javax.xml.stream.XMLInputFactory", "com.ctc.wstx.stax.WstxInputFactory");
        }
        try {
            WsimportTool compileTool = new WsimportTool((OutputStream)stream);
            compileTool.setEntityResolver((EntityResolver)new JBossWSEntityResolver());
            boolean success = compileTool.run(args.toArray(new String[args.size()]));
            if (!success) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"WSIMPORT_INVOCATION_FAILED", (Object[])new Object[0]));
            }
        }
        catch (RuntimeException rte) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke WsImport");
                rte.printStackTrace(this.messageStream);
            } else {
                rte.printStackTrace();
            }
            throw rte;
        }
        finally {
            this.resetSystemProperty("java.class.path", javaClassPath);
            this.resetSystemProperty("javax.xml.stream.XMLInputFactory", xmlInputFactory);
        }
    }

    private void resetSystemProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }
}

