/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.config.jaxrpc.CommonConfigJAXRPC;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class EndpointConfigMetaData {
    private static Logger log = Logger.getLogger(EndpointConfigMetaData.class);
    private final EndpointMetaData epMetaData;
    protected String configName;
    protected String configFile;
    private CommonConfig config;
    private List<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
    private boolean handlersInitialized;

    public EndpointConfigMetaData(EndpointMetaData parent) {
        this.epMetaData = parent;
    }

    void addHandlers(List<HandlerMetaData> configHandlers) {
        for (HandlerMetaData handler : configHandlers) {
            handler.setEndpointMetaData(this.epMetaData);
        }
        this.handlers.addAll(configHandlers);
    }

    void addHandler(HandlerMetaData handler) {
        handler.setEndpointMetaData(this.epMetaData);
        this.handlers.add(handler);
    }

    void clearHandlers() {
        this.handlers.clear();
        this.handlersInitialized = false;
    }

    public List<HandlerMetaData> getHandlerMetaData(UnifiedHandlerMetaData.HandlerType type) {
        ArrayList<HandlerMetaData> typeHandlers = new ArrayList<HandlerMetaData>();
        for (HandlerMetaData hmd : this.handlers) {
            if (hmd.getHandlerType() != type && type != UnifiedHandlerMetaData.HandlerType.ALL) continue;
            typeHandlers.add(hmd);
        }
        return typeHandlers;
    }

    public boolean isHandlersInitialized() {
        return this.handlersInitialized;
    }

    public void setHandlersInitialized(boolean flag) {
        this.handlersInitialized = flag;
    }

    void configHandlerMetaData() {
        log.debug((Object)"Configure EndpointMetaData");
        List<HandlerMetaData> sepHandlers = this.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ENDPOINT);
        this.clearHandlers();
        List<HandlerMetaData> preHandlers = this.getHandlers(this.epMetaData, UnifiedHandlerMetaData.HandlerType.PRE);
        List<HandlerMetaData> postHandlers = this.getHandlers(this.epMetaData, UnifiedHandlerMetaData.HandlerType.POST);
        this.addHandlers(preHandlers);
        this.addHandlers(sepHandlers);
        this.addHandlers(postHandlers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Added " + preHandlers.size() + " PRE handlers"));
            log.debug((Object)("Added " + sepHandlers.size() + " ENDPOINT handlers"));
            log.debug((Object)("Added " + postHandlers.size() + " POST handlers"));
        }
    }

    private List<HandlerMetaData> getHandlers(EndpointMetaData epMetaData, UnifiedHandlerMetaData.HandlerType type) {
        List handlerChains = this.config.getHandlers(type);
        boolean isJAXRPCConfig = this.config instanceof CommonConfigJAXRPC;
        ArrayList<HandlerMetaData> handlers = new ArrayList<HandlerMetaData>();
        if (handlerChains != null) {
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    HandlerMetaData hmd = isJAXRPCConfig ? HandlerMetaDataJAXRPC.newInstance(uhmd, type) : HandlerMetaDataJAXWS.newInstance(uhmd, type);
                    hmd.setEndpointMetaData(epMetaData);
                    handlers.add(hmd);
                }
            }
        }
        return handlers;
    }

    public EndpointMetaData getEndpointMetaData() {
        return this.epMetaData;
    }

    void validate() {
        for (HandlerMetaData handler : this.handlers) {
            handler.validate();
        }
    }

    void initializeInternal() {
        for (HandlerMetaData handler : this.handlers) {
            handler.eagerInitialize();
        }
    }

    public CommonConfig getConfig() {
        return this.config;
    }

    void setConfig(CommonConfig config) {
        this.config = config;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

