/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.feature;

import java.util.ResourceBundle;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import org.jboss.ws.api.util.BundleUtils;

public final class ChunkedEncodingFeature
extends WebServiceFeature {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ChunkedEncodingFeature.class);
    public static final String ID = "http://www.jboss.org/jbossws/features/chunkedencoding";
    protected int chunkSize = 1024;

    public ChunkedEncodingFeature() {
        this.enabled = true;
    }

    public ChunkedEncodingFeature(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.chunkSize = 0;
        }
    }

    public ChunkedEncodingFeature(int chunkSize) {
        if (chunkSize < 0) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CHUNKSIZE_ERROR", (Object[])new Object[]{chunkSize}));
        }
        this.chunkSize = chunkSize;
        this.enabled = chunkSize > 0;
    }

    public String getID() {
        return ID;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }
}

