/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.xml.ws.WebServiceException;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.client.transport.WSServerPipelineFactory;
import org.jboss.ws.core.server.netty.AbstractNettyRequestHandler;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.ws.core.server.netty.NettyHttpServer;
import org.jboss.ws.core.server.netty.NettyHttpServerFactory;
import org.jboss.ws.core.server.netty.NettyHttpServerShutdownHook;
import org.jboss.ws.core.server.netty.NettyRequestHandlerFactory;

final class NettyHttpServerImpl
implements NettyHttpServer,
Runnable {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NettyHttpServerImpl.class);
    private static final long WAIT_PERIOD = 100L;
    static final ChannelGroup NETTY_CHANNEL_GROUP = new DefaultChannelGroup("NettyHttpServer");
    private final int port;
    private boolean stopped;
    private ChannelFactory channelFactory;
    private AbstractNettyRequestHandler nettyRequestHandler;

    NettyHttpServerImpl(int port, NettyRequestHandlerFactory<?> nettyRequestHandlerFactory) {
        this.port = port;
        try {
            this.channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
            ServerBootstrap bootstrap = new ServerBootstrap(this.channelFactory);
            this.nettyRequestHandler = nettyRequestHandlerFactory.newNettyRequestHandler();
            WSServerPipelineFactory channelPipelineFactory = new WSServerPipelineFactory();
            channelPipelineFactory.setRequestHandler((ChannelHandler)this.nettyRequestHandler);
            bootstrap.setPipelineFactory((ChannelPipelineFactory)channelPipelineFactory);
            bootstrap.setOption("child.tcpNoDelay", (Object)true);
            bootstrap.setOption("child.keepAlive", (Object)true);
            Channel c = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
            NETTY_CHANNEL_GROUP.add((Object)c);
            Thread t = new Thread((Runnable)this, "NettyHttpServer listening on port " + port);
            t.setDaemon(true);
            t.start();
            NettyHttpServerShutdownHook shutdownHook = new NettyHttpServerShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(new Thread((Runnable)shutdownHook, "NettyHttpServerShutdownHook(port=" + port + ")"));
        }
        catch (Exception e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized void registerCallback(NettyCallbackHandler callback) {
        if (callback != null) {
            this.ensureUpAndRunning();
            this.nettyRequestHandler.registerCallback(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unregisterCallback(NettyCallbackHandler callback) {
        if (callback != null) {
            this.ensureUpAndRunning();
            try {
                this.nettyRequestHandler.unregisterCallback(callback);
            }
            finally {
                if (!this.hasMoreCallbacks()) {
                    this.terminate();
                }
            }
        }
    }

    @Override
    public synchronized NettyCallbackHandler getCallback(String requestPath) {
        if (requestPath == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_REQUEST_PATH", (Object[])new Object[0]));
        }
        this.ensureUpAndRunning();
        return this.nettyRequestHandler.getCallback(requestPath);
    }

    @Override
    public synchronized boolean hasMoreCallbacks() {
        this.ensureUpAndRunning();
        return this.nettyRequestHandler.hasMoreCallbacks();
    }

    @Override
    public synchronized int getPort() {
        this.ensureUpAndRunning();
        return this.port;
    }

    @Override
    public synchronized void run() {
        while (!this.stopped) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        Map<Integer, NettyHttpServer> map = NettyHttpServerFactory.SERVERS;
        synchronized (map) {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            try {
                NETTY_CHANNEL_GROUP.close().awaitUninterruptibly();
                if (this.channelFactory != null) {
                    this.channelFactory.releaseExternalResources();
                }
            }
            finally {
                NettyHttpServerFactory.SERVERS.remove(this.port);
            }
        }
    }

    private void ensureUpAndRunning() {
        if (this.stopped) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SERVER_IS_DOWN", (Object[])new Object[0]));
        }
    }
}

