/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.interfaces.ParsedInterfaceCriteria;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class InterfaceAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    private static final AttributeDefinition[] ATTRIBUTES = InterfaceDescription.ROOT_ATTRIBUTES;
    public static final String OPERATION_NAME = "add";
    public static final InterfaceAddHandler NAMED_INSTANCE = new InterfaceAddHandler(false);
    public static final InterfaceAddHandler SPECIFIED_INSTANCE = new InterfaceAddHandler(true);
    private final boolean specified;

    public static ModelNode getAddInterfaceOperation(ModelNode address, ModelNode criteria) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!criteria.hasDefined(def.getName())) continue;
            op.get(def.getName()).set(criteria.get(def.getName()));
        }
        return op;
    }

    protected InterfaceAddHandler(boolean specified) {
        this.specified = specified;
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        model.get("name").set(address.getLastElement().getValue());
        for (AttributeDefinition definition : ATTRIBUTES) {
            if (!this.specified && !operation.hasDefined(definition.getName())) continue;
            this.validateAndSet(definition, operation, model);
        }
    }

    protected void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.required(attributeName)));
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalid(attributeName)));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String name = this.getInterfaceName(operation);
        ParsedInterfaceCriteria parsed = this.getCriteria(context, operation);
        if (parsed.getFailureMessage() != null) {
            throw new OperationFailedException(new ModelNode().set(parsed.getFailureMessage()));
        }
        this.performRuntime(context, operation, model, verificationHandler, newControllers, name, parsed);
    }

    protected String getInterfaceName(ModelNode operation) {
        ModelNode opAddr = operation.require("address");
        return PathAddress.pathAddress(opAddr).getLastElement().getValue();
    }

    protected ParsedInterfaceCriteria getCriteria(OperationContext context, ModelNode operation) {
        return ParsedInterfaceCriteria.parse(operation, this.specified, context);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, String name, ParsedInterfaceCriteria criteria) {
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.specified ? InterfaceDescription.getSpecifiedInterfaceAddOperation(locale) : InterfaceDescription.getNamedInterfaceAddOperation(locale);
    }
}

