/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DefaultOperationDescriptionProvider
implements DescriptionProvider {
    private final String operationName;
    private final ResourceDescriptionResolver descriptionResolver;
    private final ModelType replyType;
    private final ModelType replyValueType;
    private final AttributeDefinition[] parameters;

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, (ModelType)null, (ModelType)null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ModelType replyType, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, replyType, (ModelType)null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ModelType replyType, ModelType replyValueType, AttributeDefinition ... parameters) {
        this.operationName = operationName;
        this.descriptionResolver = descriptionResolver;
        this.replyType = replyType;
        this.replyValueType = replyValueType;
        this.parameters = parameters;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("operation-name").set(this.operationName);
        result.get("description").set(this.descriptionResolver.getOperationDescription(this.operationName, locale, bundle2));
        result.get("request-properties").setEmptyObject();
        if (this.parameters != null) {
            for (AttributeDefinition definition : this.parameters) {
                definition.addOperationParameterDescription(result, this.operationName, this.descriptionResolver, locale, bundle2);
            }
        }
        ModelNode reply = result.get("reply-properties").setEmptyObject();
        String replyDesc = this.descriptionResolver.getOperationReplyDescription(this.operationName, locale, bundle2);
        if (replyDesc != null) {
            reply.get("description").set(replyDesc);
        }
        if (this.replyType != null && this.replyType != ModelType.UNDEFINED) {
            reply.get("type").set(this.replyType);
            if (this.replyType == ModelType.LIST || this.replyType == ModelType.OBJECT) {
                if (this.replyValueType != null && this.replyValueType != ModelType.OBJECT) {
                    reply.get("value-type").set(this.replyValueType);
                } else {
                    reply.get("value-type").set(this.getReplyValueTypeDescription(this.descriptionResolver, locale, bundle2));
                }
            }
        }
        return result;
    }

    protected ModelNode getReplyValueTypeDescription(ResourceDescriptionResolver descriptionResolver, Locale locale, ResourceBundle bundle2) {
        throw ControllerMessages.MESSAGES.operationReplyValueTypeRequired(this.operationName);
    }
}

