/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.controller.client.impl.ProtocolConfigurationFactory;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.OptionMap;

public class RemotingModelControllerClient
extends AbstractModelControllerClient {
    private Endpoint endpoint;
    private ManagementClientChannelStrategy strategy;
    private boolean closed;
    private final ModelControllerClientConfiguration clientConfiguration;

    public RemotingModelControllerClient(ModelControllerClientConfiguration configuration) {
        super(configuration.getExecutor());
        this.clientConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RemotingModelControllerClient remotingModelControllerClient = this;
        synchronized (remotingModelControllerClient) {
            this.closed = true;
            if (this.endpoint != null) {
                this.endpoint.close();
                this.endpoint = null;
            }
            if (this.strategy != null) {
                this.strategy.close();
                this.strategy = null;
            }
            super.shutdownNow();
        }
    }

    @Override
    protected synchronized Channel getChannel() throws IOException {
        if (this.closed) {
            throw ControllerClientMessages.MESSAGES.objectIsClosed(ModelControllerClient.class.getSimpleName());
        }
        if (this.strategy == null) {
            try {
                ProtocolChannelClient.Configuration configuration = ProtocolConfigurationFactory.create(this.clientConfiguration);
                this.endpoint = Remoting.createEndpoint((String)"management-client", (OptionMap)OptionMap.EMPTY);
                this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.EMPTY);
                configuration.setEndpoint(this.endpoint);
                configuration.setEndpointName("management-client");
                ProtocolChannelClient setup = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)configuration);
                this.strategy = ManagementClientChannelStrategy.create((ProtocolChannelClient)setup, (ManagementMessageHandler)this, (CallbackHandler)this.clientConfiguration.getCallbackHandler(), this.clientConfiguration.getSaslOptions(), (SSLContext)this.clientConfiguration.getSSLContext());
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.strategy.getChannel();
    }
}

