/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ControllerClientMessages;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class RemotingModelControllerClient
extends AbstractModelControllerClient {
    private final String hostName;
    private final int port;
    private final CallbackHandler callbackHandler;
    private final Map<String, String> saslOptions;
    private volatile Endpoint endpoint;
    private ManagementClientChannelStrategy strategy;
    private boolean closed;

    public RemotingModelControllerClient(String hostName, int port, CallbackHandler callbackHandler, Map<String, String> saslOptions) {
        this.hostName = hostName;
        this.port = port;
        this.callbackHandler = callbackHandler;
        this.saslOptions = saslOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RemotingModelControllerClient remotingModelControllerClient = this;
        synchronized (remotingModelControllerClient) {
            this.closed = true;
            if (this.endpoint != null) {
                this.endpoint.close();
                this.endpoint = null;
            }
        }
        super.close();
    }

    @Override
    protected synchronized ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException {
        if (this.closed) {
            throw ControllerClientMessages.MESSAGES.objectIsClosed(ModelControllerClient.class.getSimpleName());
        }
        if (this.strategy == null) {
            this.endpoint = Remoting.createEndpoint((String)"management-client", (OptionMap)OptionMap.EMPTY);
            this.endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
            this.strategy = ManagementClientChannelStrategy.create((String)this.hostName, (int)this.port, (Endpoint)this.endpoint, (ManagementOperationHandler)this, (CallbackHandler)this.callbackHandler, this.saslOptions);
        }
        return this.strategy;
    }
}

