/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.drone.webdriver.spi.BrowserCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.safari.SafariOptions;

public class BrowserCapabilitiesList {

    public static class ChromeHeadless
    implements BrowserCapabilities {
        public String getReadableName() {
            return "chromeheadless";
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.chrome.ChromeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.CHROME.asMap();
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Safari
    implements BrowserCapabilities {
        public String getReadableName() {
            return "safari";
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.safari.SafariDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.SAFARI.asMap();
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Remote
    implements BrowserCapabilities {
        public String getReadableName() {
            return null;
        }

        public String getImplementationClassName() {
            return "org.openqa.selenium.remote.RemoteWebDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return null;
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class InternetExplorer
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.ie.InternetExplorerDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.IE.asMap();
        }

        public String getReadableName() {
            return "internetexplorer";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class HtmlUnit
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.jboss.arquillian.drone.webdriver.htmlunit.DroneHtmlUnitDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Collections.emptyMap();
        }

        public String getReadableName() {
            return "htmlunit";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Firefox
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.firefox.FirefoxDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.FIREFOX.asMap();
        }

        public String getReadableName() {
            return "firefox";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Edge
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.edge.EdgeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.EDGE.asMap();
        }

        public String getReadableName() {
            return "edge";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Chrome
    implements BrowserCapabilities {
        public String getImplementationClassName() {
            return "org.openqa.selenium.chrome.ChromeDriver";
        }

        public Map<String, ?> getRawCapabilities() {
            return Capabilities.CHROME.asMap();
        }

        public String getReadableName() {
            return "chrome";
        }

        public int getPrecedence() {
            return 0;
        }
    }

    public static class Capabilities {
        public static ChromeOptions CHROME = new ChromeOptions();
        public static EdgeOptions EDGE = new EdgeOptions();
        public static FirefoxOptions FIREFOX = new FirefoxOptions();
        public static InternetExplorerOptions IE = new InternetExplorerOptions();
        public static SafariOptions SAFARI = new SafariOptions();
    }
}

