/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.Collection;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.instrument.JoinpointClassification;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutInfo;

public abstract class JoinpointClassifier {
    private Matcher fieldGetMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesGet(advisor, (CtField)member);
        }

        public String getJoinpointDescription(CtMember member) {
            return member + " field read joinpoint";
        }
    };
    private Matcher fieldSetMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesSet(advisor, (CtField)member);
        }

        public String getJoinpointDescription(CtMember member) {
            return member + " field write joinpoint";
        }
    };
    private Matcher constructorMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesExecution(advisor, (CtConstructor)member);
        }

        public String getJoinpointDescription(CtMember member) {
            return member + " constructor execution joinpoint";
        }
    };
    private Matcher methodMatcher = new Matcher(){

        public boolean matches(Pointcut pointcut, Advisor advisor, CtMember member) throws NotFoundException {
            return pointcut.matchesExecution(advisor, (CtMethod)member);
        }

        public String getJoinpointDescription(CtMember member) {
            return member + " method execution joinpoint";
        }
    };
    private BindingCollectionAccessor fieldGetAccessor = new BindingCollectionAccessor(){

        @Override
        public Collection<PointcutInfo> getPointcutInfos(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getFieldReadPointcutInfos();
        }

        @Override
        public Collection<Pointcut> getPointcuts(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getFieldReadPointcuts();
        }
    };
    private BindingCollectionAccessor fieldSetAccessor = new BindingCollectionAccessor(){

        @Override
        public Collection<PointcutInfo> getPointcutInfos(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getFieldWritePointcutInfos();
        }

        @Override
        public Collection<Pointcut> getPointcuts(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getFieldWritePointcuts();
        }
    };
    private BindingCollectionAccessor constructorAccessor = new BindingCollectionAccessor(){

        @Override
        public Collection<PointcutInfo> getPointcutInfos(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getConstructorExecutionPointcutInfos();
        }

        @Override
        public Collection<Pointcut> getPointcuts(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getConstructorExecutionPointcuts();
        }
    };
    private BindingCollectionAccessor methodAccessor = new BindingCollectionAccessor(){

        @Override
        public Collection<PointcutInfo> getPointcutInfos(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getMethodExecutionPointcutInfos();
        }

        @Override
        public Collection<Pointcut> getPointcuts(Advisor advisor) {
            return advisor.getManager().getBindingCollection().getMethodExecutionPointcuts();
        }
    };

    protected abstract JoinpointClassification classifyJoinpoint(CtMember var1, Advisor var2, Matcher var3, BindingCollectionAccessor var4) throws NotFoundException;

    public JoinpointClassification classifyFieldGet(CtField field, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)field, advisor, this.fieldGetMatcher, this.fieldGetAccessor);
    }

    public JoinpointClassification classifyFieldSet(CtField field, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)field, advisor, this.fieldSetMatcher, this.fieldSetAccessor);
    }

    public JoinpointClassification classifyConstructorExecution(CtConstructor cons, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)cons, advisor, this.constructorMatcher, this.constructorAccessor);
    }

    public JoinpointClassification classifyMethodExecution(CtMethod method, Advisor advisor) throws NotFoundException {
        return this.classifyJoinpoint((CtMember)method, advisor, this.methodMatcher, this.methodAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface BindingCollectionAccessor {
        public Collection<Pointcut> getPointcuts(Advisor var1);

        public Collection<PointcutInfo> getPointcutInfos(Advisor var1);
    }

    protected static interface Matcher {
        public boolean matches(Pointcut var1, Advisor var2, CtMember var3) throws NotFoundException;

        public String getJoinpointDescription(CtMember var1);
    }
}

