/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Modifier;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyMethodInvocation;

public class PerJoinpointInterceptor
implements Interceptor {
    AspectDefinition aspectDefinition;
    Joinpoint joinpoint;

    public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def) throws Exception {
        if (joinpoint instanceof MethodJoinpoint) {
            MethodJoinpoint method = (MethodJoinpoint)joinpoint;
            if (Modifier.isStatic(method.getMethod().getModifiers())) {
                return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
        } else {
            FieldJoinpoint field;
            if (joinpoint instanceof ConstructorJoinpoint) {
                return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
            if (joinpoint instanceof MethodCalledByMethodJoinpoint) {
                MethodCalledByMethodJoinpoint method = (MethodCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
                }
            } else if (joinpoint instanceof ConstructorCalledByMethodJoinpoint) {
                ConstructorCalledByMethodJoinpoint method = (ConstructorCalledByMethodJoinpoint)joinpoint;
                if (Modifier.isStatic(method.getCalling().getModifiers())) {
                    return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
                }
            } else if (joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = (FieldJoinpoint)joinpoint).getField().getModifiers())) {
                ClassAdvisor classAdvisor = (ClassAdvisor)advisor;
                return (Interceptor)classAdvisor.getFieldAspect(field, def);
            }
        }
        return new PerJoinpointInterceptor(def, advisor, joinpoint);
    }

    public PerJoinpointInterceptor(AspectDefinition a, Advisor advisor, Joinpoint joinpoint) {
        this.aspectDefinition = a;
        advisor.addPerInstanceJoinpointAspect(joinpoint, a);
        this.joinpoint = joinpoint;
    }

    public String getName() {
        return this.aspectDefinition.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof CallerInvocation) {
            Advised advised;
            InstanceAdvisor advisor;
            Interceptor interceptor;
            Object callingObject = ((CallerInvocation)invocation).getCallingObject();
            if (callingObject != null && (interceptor = (Interceptor)(advisor = (advised = (Advised)callingObject)._getInstanceAdvisor()).getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition)) != null) {
                return interceptor.invoke(invocation);
            }
        } else {
            Interceptor interceptor;
            InstanceAdvisor instanceAdvisor;
            Object targetObject = invocation.getTargetObject();
            if (targetObject != null && (instanceAdvisor = this.getInstanceAdvisor(invocation, targetObject)) != null && (interceptor = this.getAspectInstance(instanceAdvisor)) != null) {
                return interceptor.invoke(invocation);
            }
        }
        return invocation.invokeNext();
    }

    private InstanceAdvisor getInstanceAdvisor(Invocation invocation, Object targetObject) {
        if (targetObject instanceof Advised) {
            Advised advised = (Advised)targetObject;
            return advised._getInstanceAdvisor();
        }
        Advisor advisor = invocation.getAdvisor();
        if (advisor == null) {
            return null;
        }
        if (advisor instanceof InstanceAdvisor) {
            return (InstanceAdvisor)((Object)advisor);
        }
        if (advisor instanceof ClassProxyContainer && invocation instanceof ContainerProxyMethodInvocation) {
            ContainerProxyMethodInvocation pi = (ContainerProxyMethodInvocation)invocation;
            return pi.getProxy().getInstanceAdvisor();
        }
        return null;
    }

    public Interceptor getAspectInstance(InstanceAdvisor ia) {
        return (Interceptor)ia.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
    }
}

