/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.mock;

import java.lang.reflect.Method;
import org.jboss.aop.Aspect;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aspects.mock.Replace;

@Aspect(scope=Scope.PER_VM)
public class MockAspect
implements Interceptor {
    private static String callbackClass;
    private static String callbackMethod;
    private static long expectedCalls;
    private static long realCalls;
    private final String BINDING_NAME = "_TestBinding";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bind(pointcut="execution(* *->@org.jboss.aspects.mock.Replace(..))")
    public Object advise(Invocation i) throws Throwable {
        try {
            MethodInvocation mi = (MethodInvocation)i;
            Replace annotation = mi.getMethod().getAnnotation(Replace.class);
            String invocation = "execution(* " + annotation.invocation() + ")";
            callbackClass = annotation.callbackClass();
            callbackMethod = annotation.callbackMethod();
            expectedCalls = annotation.expectedCalls();
            AdviceBinding binding = new AdviceBinding("_TestBinding", invocation, null);
            binding.addInterceptor(MockAspect.class);
            AspectManager.instance().addBinding(binding);
            Object object = i.invokeNext();
            return object;
        }
        finally {
            AspectManager.instance().removeBinding("_TestBinding");
            if (realCalls < expectedCalls && expectedCalls < Long.MAX_VALUE) {
                throw new RuntimeException("Method: " + callbackMethod + " was called less than the expected " + expectedCalls + " times! (" + realCalls + " times)");
            }
            realCalls = 0L;
        }
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (++realCalls > expectedCalls) {
            throw new RuntimeException("Method: " + callbackMethod + " was called more than the expected " + expectedCalls + " times!");
        }
        MethodInvocation mi = (MethodInvocation)invocation;
        Class<?> clazz = Class.forName(callbackClass);
        Method method = clazz.getDeclaredMethod(callbackMethod, mi.getActualMethod().getParameterTypes());
        return method.invoke(clazz.newInstance(), mi.getArguments());
    }

    public String getName() {
        return "Conduct Isolate Aspect and Interceptor";
    }
}

