/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.jasig.maven.plugin.sass.CompilerCallback;
import org.jasig.maven.plugin.sass.Resource;

public abstract class AbstractSassMojo
extends AbstractMojo {
    protected List<Resource> resources;
    protected String[] gemPaths = new String[0];
    protected String[] gems = new String[0];
    protected File buildDirectory;
    protected boolean failOnError;
    protected Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));
    protected boolean useCompass;
    protected File sassSourceDirectory;
    protected String[] includes = new String[]{"**/scss"};
    protected String[] excludes;
    protected String relativeOutputDirectory;
    protected File destination;

    protected void executeSassScript(String sassScript) throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        System.setProperty("org.jruby.embed.localcontext.scope", "threadsafe");
        log.debug((CharSequence)("Execute SASS Ruby Script:\n" + sassScript));
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine jruby = scriptEngineManager.getEngineByName("jruby");
        try {
            CompilerCallback compilerCallback = new CompilerCallback(log);
            jruby.getBindings(100).put("compiler_callback", (Object)compilerCallback);
            jruby.eval(sassScript);
            if (this.failOnError && compilerCallback.hadError()) {
                throw new MojoFailureException("SASS compilation encountered errors (see above for details).");
            }
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("Failed to execute SASS ruby script:\n" + sassScript, (Exception)e);
        }
    }

    protected void buildBasicSASSScript(StringBuilder sassScript) throws MojoExecutionException {
        Iterator<Map.Entry<String, String>> templateLocations;
        Log log = this.getLog();
        sassScript.append("require 'rubygems'\n");
        if (this.gemPaths.length > 0) {
            sassScript.append("env = { 'GEM_PATH' => [\n");
            for (String gemPath : this.gemPaths) {
                sassScript.append("    '").append(gemPath).append("',\n");
            }
            sassScript.setLength(sassScript.length() - 2);
            sassScript.append("\n");
            sassScript.append("] }\n");
            sassScript.append("env['GEM_PATH'] += ENV['GEM_PATH'] unless ENV['GEM_PATH'].nil?\n");
            sassScript.append("Gem.paths = env\n");
        }
        for (String gem : this.gems) {
            sassScript.append("require '").append(gem).append("'\n");
        }
        sassScript.append("require 'sass/plugin'\n");
        sassScript.append("require 'java'\n");
        if (this.useCompass) {
            log.info((CharSequence)"Running with Compass enabled.");
            sassScript.append("require 'compass'\n");
            sassScript.append("require 'compass/exec'\n");
            sassScript.append("Compass.add_project_configuration \n");
            this.sassOptions.put("load_paths", "Compass.configuration.sass_load_paths");
            sassScript.append("Compass::Frameworks.register_directory('jar:'+ File.join(Compass.base_directory, 'frameworks/compass'))\n");
            sassScript.append("Compass::Frameworks.register_directory('jar:'+ File.join(Compass.base_directory, 'frameworks/blueprint'))\n");
        }
        if ((templateLocations = this.getTemplateLocations()).hasNext()) {
            Map.Entry<String, String> location = templateLocations.next();
            this.sassOptions.put("template_location", "'" + location.getKey() + "'");
            this.sassOptions.put("css_location", "'" + location.getValue() + "'");
        }
        if (!this.sassOptions.containsKey("cache_location")) {
            File sassCacheDir = new File(this.buildDirectory, "sass_cache");
            String sassCacheDirStr = sassCacheDir.toString();
            this.sassOptions.put("cache_location", "'" + FilenameUtils.separatorsToUnix((String)sassCacheDirStr) + "'");
        }
        sassScript.append("Sass::Plugin.options.merge!(\n");
        Iterator<Map.Entry<String, String>> entryItr = this.sassOptions.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, String> optEntry = entryItr.next();
            String opt = optEntry.getKey();
            String value = optEntry.getValue();
            sassScript.append("    :").append(opt).append(" => ").append(value);
            if (entryItr.hasNext()) {
                sassScript.append(",");
            }
            sassScript.append("\n");
        }
        sassScript.append(")\n");
        while (templateLocations.hasNext()) {
            Map.Entry<String, String> location = templateLocations.next();
            sassScript.append("Sass::Plugin.add_template_location('").append(location.getKey()).append("', '").append(location.getValue()).append("')\n");
        }
        sassScript.append("Sass::Plugin.on_compilation_error {|error, template, css| $compiler_callback.compilationError(error.message, template, css) }\n");
        sassScript.append("Sass::Plugin.on_updated_stylesheet {|template, css| $compiler_callback.updatedStylesheeet(template, css) }\n");
        sassScript.append("Sass::Plugin.on_template_modified {|template| $compiler_callback.templateModified(template) }\n");
        sassScript.append("Sass::Plugin.on_template_created {|template| $compiler_callback.templateCreated(template) }\n");
        sassScript.append("Sass::Plugin.on_template_deleted {|template| $compiler_callback.templateDeleted(template) }\n");
        if (log.isDebugEnabled()) {
            sassScript.append("require 'pp'\npp Sass::Plugin.options\n");
            if (this.useCompass) {
                sassScript.append("pp Compass::configuration\n");
            }
        }
    }

    private Iterator<Map.Entry<String, String>> getTemplateLocations() {
        Log log = this.getLog();
        ImmutableList r = this.resources;
        if (r == null) {
            Resource resource = new Resource();
            resource.source = new FileSet();
            resource.source.setDirectory(this.sassSourceDirectory.toString());
            if (this.includes != null) {
                resource.source.setIncludes(Arrays.asList(this.includes));
            }
            if (this.excludes != null) {
                resource.source.setExcludes(Arrays.asList(this.excludes));
            }
            resource.relativeOutputDirectory = this.relativeOutputDirectory;
            resource.destination = this.destination;
            r = ImmutableList.of((Object)resource);
        }
        ArrayList<Map.Entry<String, String>> locations = new ArrayList<Map.Entry<String, String>>();
        for (Resource source : r) {
            for (Map.Entry<String, String> entry : source.getDirectoriesAndDestinations().entrySet()) {
                log.info((CharSequence)("Queing SASS Template for compile: " + entry.getKey() + " => " + entry.getValue()));
                locations.add(entry);
            }
        }
        return locations.iterator();
    }
}

