/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jacoco.report.ISourceFileLocator;

public class DirectorySourceFileLocator
implements ISourceFileLocator {
    private final File directory;
    private final String encoding;
    private final int tabWidth;

    public DirectorySourceFileLocator(File directory, String encoding, int tabWidth) {
        this.directory = directory;
        this.encoding = encoding;
        this.tabWidth = tabWidth;
    }

    public Reader getSourceFile(String packageName, String fileName) throws IOException {
        File dir = new File(this.directory, packageName);
        File file = new File(dir, fileName);
        if (file.exists()) {
            return new InputStreamReader((InputStream)new FileInputStream(file), this.encoding);
        }
        return null;
    }

    public int getTabWidth() {
        return this.tabWidth;
    }
}

