/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationFormatFeature;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.configuration.AddressType;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.InterfaceConfiguration;
import org.infinispan.server.configuration.InterfacesConfiguration;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.configuration.SocketBindingConfiguration;
import org.infinispan.server.configuration.SocketBindingsConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointConfiguration;
import org.infinispan.server.configuration.endpoint.EndpointsConfiguration;
import org.infinispan.server.configuration.rest.Element;
import org.infinispan.server.configuration.security.AggregateRealmConfiguration;
import org.infinispan.server.configuration.security.CredentialStoreConfiguration;
import org.infinispan.server.configuration.security.CredentialStoresConfiguration;
import org.infinispan.server.configuration.security.CredentialStoresConfigurationBuilder;
import org.infinispan.server.configuration.security.DistributedRealmConfiguration;
import org.infinispan.server.configuration.security.KerberosSecurityFactoryConfiguration;
import org.infinispan.server.configuration.security.LdapAttributeConfiguration;
import org.infinispan.server.configuration.security.LdapIdentityMappingConfiguration;
import org.infinispan.server.configuration.security.LdapRealmConfiguration;
import org.infinispan.server.configuration.security.LocalRealmConfiguration;
import org.infinispan.server.configuration.security.PropertiesRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfiguration;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.RealmsConfiguration;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;
import org.infinispan.server.configuration.security.TokenRealmConfiguration;
import org.infinispan.server.configuration.security.TrustStoreConfiguration;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.security.PasswordCredentialSource;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.credential.source.CredentialSource;

public class ServerConfigurationSerializer
implements ConfigurationSerializer<ServerConfiguration> {
    public static final CredentialSerializer CREDENTIAL = new CredentialSerializer();
    public static final CredentialProxySerializer CREDENTIAL_PROXY = new CredentialProxySerializer();

    public void serialize(ConfigurationWriter writer, ServerConfiguration configuration) {
        writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SERVER);
        writer.writeDefaultNamespace("urn:infinispan:server:" + Version.getMajorMinor());
        this.writeInterfaces(writer, configuration.interfaces);
        this.writeSocketBindings(writer, configuration.socketBindings);
        this.writeSecurity(writer, configuration.security());
        this.writeDataSources(writer, configuration.dataSources());
        this.writeEndpoints(writer, configuration.endpoints());
        writer.writeEndElement();
    }

    private void writeInterfaces(ConfigurationWriter writer, InterfacesConfiguration networkInterfaces) {
        writer.writeStartListElement((Enum)org.infinispan.server.configuration.Element.INTERFACES, true);
        for (InterfaceConfiguration netIf : networkInterfaces.interfaces().values()) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.INTERFACE);
            writer.writeAttribute((Enum)Attribute.NAME, netIf.name());
            AddressType addressType = netIf.addressConfiguration().addressType();
            if (addressType.hasValue()) {
                writer.writeStartElement((Enum)addressType);
                writer.writeAttribute((Enum)Attribute.VALUE, netIf.addressConfiguration().value());
                writer.writeEndElement();
            } else {
                writer.writeEmptyElement((Enum)addressType);
            }
            writer.writeEndElement();
        }
        writer.writeEndListElement();
    }

    private void writeSocketBindings(ConfigurationWriter writer, SocketBindingsConfiguration socketBindings) {
        if (writer.hasFeature(ConfigurationFormatFeature.MIXED_ELEMENTS)) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SOCKET_BINDINGS);
            socketBindings.attributes().write(writer);
            for (SocketBindingConfiguration socketBinding : socketBindings.socketBindings().values()) {
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SOCKET_BINDING);
                socketBinding.attributes().write(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SOCKET_BINDINGS);
            socketBindings.attributes().write(writer);
            writer.writeStartArrayElement((Enum)org.infinispan.server.configuration.Element.SOCKET_BINDING);
            for (SocketBindingConfiguration socketBinding : socketBindings.socketBindings().values()) {
                socketBinding.write(writer);
            }
            writer.writeEndArrayElement();
            writer.writeEndElement();
        }
    }

    private void writeSecurity(ConfigurationWriter writer, SecurityConfiguration security) {
        writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SECURITY);
        this.writeCredentialStores(writer, security.credentialStores());
        this.writeSecurityRealms(writer, security.realms());
        writer.writeEndElement();
    }

    private void writeCredentialStores(ConfigurationWriter writer, CredentialStoresConfiguration credentialStores) {
        if (!credentialStores.credentialStores().isEmpty()) {
            writer.writeStartArrayElement((Enum)org.infinispan.server.configuration.Element.CREDENTIAL_STORES);
            for (CredentialStoreConfiguration credentialStore : credentialStores.credentialStores().values()) {
                credentialStore.write(writer);
            }
            writer.writeEndArrayElement();
        }
    }

    private void writeSecurityRealms(ConfigurationWriter writer, RealmsConfiguration realms) {
        if (!realms.realms().isEmpty()) {
            writer.writeStartArrayElement((Enum)org.infinispan.server.configuration.Element.SECURITY_REALMS);
            for (Map.Entry<String, RealmConfiguration> e : realms.realms().entrySet()) {
                RealmConfiguration realm = e.getValue();
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SECURITY_REALM);
                realm.attributes().write(writer);
                this.writeServerIdentities(writer, realm.serverIdentitiesConfiguration());
                for (RealmProvider provider : realm.realmProviders()) {
                    if (provider instanceof LdapRealmConfiguration) {
                        this.writeRealm(writer, (LdapRealmConfiguration)provider);
                        continue;
                    }
                    if (provider instanceof LocalRealmConfiguration) {
                        this.writeRealm(writer, (LocalRealmConfiguration)provider);
                        continue;
                    }
                    if (provider instanceof PropertiesRealmConfiguration) {
                        this.writeRealm(writer, (PropertiesRealmConfiguration)provider);
                        continue;
                    }
                    if (provider instanceof TokenRealmConfiguration) {
                        this.writeRealm(writer, (TokenRealmConfiguration)provider);
                        continue;
                    }
                    if (provider instanceof TrustStoreConfiguration) {
                        this.writeRealm(writer, (TrustStoreRealmConfiguration)provider);
                        continue;
                    }
                    if (provider instanceof DistributedRealmConfiguration) {
                        this.writeRealm(writer, (DistributedRealmConfiguration)provider);
                        continue;
                    }
                    if (!(provider instanceof AggregateRealmConfiguration)) continue;
                    this.writeRealm(writer, (AggregateRealmConfiguration)provider);
                }
                writer.writeEndElement();
            }
            writer.writeEndArrayElement();
        }
    }

    private void writeRealm(ConfigurationWriter writer, LdapRealmConfiguration realm) {
        if (realm.name() != null) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.LDAP_REALM);
            realm.attributes().write(writer);
            NameRewriter nameRewriter = realm.nameRewriter();
            if (nameRewriter != null) {
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.NAME_REWRITER);
                if (!(nameRewriter instanceof RegexNameRewriter)) {
                    throw new IllegalArgumentException();
                }
                RegexNameRewriter regexNameRewriter = (RegexNameRewriter)nameRewriter;
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.REGEX_PRINCIPAL_TRANSFORMER);
                writer.writeAttribute((Enum)Attribute.PATTERN, regexNameRewriter.getPattern().pattern());
                writer.writeAttribute((Enum)Attribute.REPLACEMENT, regexNameRewriter.getReplacement());
                writer.writeEndElement();
                writer.writeEndElement();
            }
            LdapIdentityMappingConfiguration identity = realm.identityMapping();
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.IDENTITY_MAPPING);
            identity.attributes().write(writer);
            if (!identity.attributeMappings().isEmpty()) {
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.ATTRIBUTE_MAPPING);
                for (LdapAttributeConfiguration mapping : identity.attributeMappings()) {
                    mapping.write(writer);
                }
                writer.writeEndElement();
            }
            identity.userPasswordMapper().attributes().write(writer, (Enum)org.infinispan.server.configuration.Element.USER_PASSWORD_MAPPER);
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeRealm(ConfigurationWriter writer, LocalRealmConfiguration realm) {
        realm.attributes().write(writer, (Enum)org.infinispan.server.configuration.Element.LOCAL_REALM);
    }

    private void writeRealm(ConfigurationWriter writer, TokenRealmConfiguration realm) {
        if (realm.name() != null) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.TOKEN_REALM);
            realm.attributes().write(writer);
            realm.jwtConfiguration().write(writer);
            realm.oauth2Configuration().write(writer);
            writer.writeEndElement();
        }
    }

    private void writeRealm(ConfigurationWriter writer, PropertiesRealmConfiguration realm) {
        if (realm.userProperties().digestRealmName() != null) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.PROPERTIES_REALM);
            realm.attributes().write(writer);
            realm.userProperties().attributes().write(writer, (Enum)org.infinispan.server.configuration.Element.USER_PROPERTIES);
            realm.groupProperties().attributes().write(writer, (Enum)org.infinispan.server.configuration.Element.GROUP_PROPERTIES);
            writer.writeEndElement();
        }
    }

    private void writeRealm(ConfigurationWriter writer, TrustStoreRealmConfiguration realm) {
        realm.write(writer);
    }

    private void writeRealm(ConfigurationWriter writer, AggregateRealmConfiguration realm) {
        realm.write(writer);
    }

    private void writeRealm(ConfigurationWriter writer, DistributedRealmConfiguration realm) {
        realm.write(writer);
    }

    private void writeServerIdentities(ConfigurationWriter writer, ServerIdentitiesConfiguration identities) {
        SSLConfiguration ssl = identities.sslConfiguration();
        List<KerberosSecurityFactoryConfiguration> kerberosList = identities.kerberosConfigurations();
        if (ssl != null || !kerberosList.isEmpty()) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SERVER_IDENTITIES);
            if (ssl != null) {
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.SSL);
                ssl.keyStore().write(writer);
                TrustStoreConfiguration trustStore = ssl.trustStore();
                if (trustStore != null) {
                    trustStore.write(writer);
                }
                ssl.engine().write(writer);
                writer.writeEndElement();
            }
            if (!kerberosList.isEmpty()) {
                for (KerberosSecurityFactoryConfiguration kerberos : kerberosList) {
                    kerberos.write(writer);
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeDataSources(ConfigurationWriter writer, Map<String, DataSourceConfiguration> dataSources) {
        if (!dataSources.isEmpty()) {
            writer.writeStartListElement((Enum)org.infinispan.server.configuration.Element.DATA_SOURCES, true);
            for (Map.Entry<String, DataSourceConfiguration> configuration : dataSources.entrySet()) {
                AttributeSet attributes = configuration.getValue().attributes();
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.DATA_SOURCE);
                attributes.write(writer, DataSourceConfiguration.NAME);
                attributes.write(writer, DataSourceConfiguration.JNDI_NAME);
                attributes.write(writer, DataSourceConfiguration.STATISTICS);
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.CONNECTION_FACTORY);
                attributes.write(writer, DataSourceConfiguration.DRIVER);
                attributes.write(writer, DataSourceConfiguration.USERNAME);
                attributes.write(writer, DataSourceConfiguration.URL);
                attributes.write(writer, DataSourceConfiguration.INITIAL_SQL);
                attributes.write(writer, DataSourceConfiguration.PASSWORD);
                attributes.write(writer, DataSourceConfiguration.CONNECTION_PROPERTIES);
                writer.writeEndElement();
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.CONNECTION_POOL);
                attributes.write(writer, DataSourceConfiguration.BACKGROUND_VALIDATION);
                attributes.write(writer, DataSourceConfiguration.BLOCKING_TIMEOUT);
                attributes.write(writer, DataSourceConfiguration.IDLE_REMOVAL);
                attributes.write(writer, DataSourceConfiguration.INITIAL_SIZE);
                attributes.write(writer, DataSourceConfiguration.LEAK_DETECTION);
                attributes.write(writer, DataSourceConfiguration.MAX_SIZE);
                attributes.write(writer, DataSourceConfiguration.MIN_SIZE);
                writer.writeEndElement();
                writer.writeEndElement();
            }
            writer.writeEndListElement();
        }
    }

    private void writeEndpoints(ConfigurationWriter writer, EndpointsConfiguration endpoints) {
        writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.ENDPOINTS);
        for (EndpointConfiguration endpoint : endpoints.endpoints()) {
            writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.ENDPOINT);
            endpoint.singlePortRouter().attributes().write(writer);
            endpoint.attributes().write(writer);
            for (ProtocolServerConfiguration<?, ?> connector : endpoint.connectors()) {
                if (connector instanceof HotRodServerConfiguration) {
                    this.writeConnector(writer, (HotRodServerConfiguration)connector);
                    continue;
                }
                if (connector instanceof RestServerConfiguration) {
                    this.writeConnector(writer, (RestServerConfiguration)connector);
                    continue;
                }
                if (connector instanceof MemcachedServerConfiguration) {
                    this.writeConnector(writer, (MemcachedServerConfiguration)connector);
                    continue;
                }
                if (!(connector instanceof RespServerConfiguration)) continue;
                RespServerConfiguration resp = (RespServerConfiguration)connector;
                this.writeConnector(writer, resp);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeConnector(ConfigurationWriter writer, HotRodServerConfiguration connector) {
        if (connector.isImplicit()) {
            return;
        }
        writer.writeStartElement((Enum)org.infinispan.server.hotrod.configuration.Element.HOTROD_CONNECTOR);
        connector.attributes().write(writer);
        connector.topologyCache().write(writer);
        if (connector.authentication().enabled()) {
            writer.writeStartElement((Enum)org.infinispan.server.hotrod.configuration.Element.AUTHENTICATION);
            connector.authentication().attributes().write(writer);
            connector.authentication().sasl().write(writer);
            writer.writeEndElement();
        }
        connector.encryption().write(writer);
        writer.writeEndElement();
    }

    private void writeConnector(ConfigurationWriter writer, RestServerConfiguration connector) {
        if (connector.isImplicit()) {
            return;
        }
        writer.writeStartElement((Enum)Element.REST_CONNECTOR);
        connector.attributes().write(writer);
        if (connector.authentication().enabled()) {
            writer.writeStartElement((Enum)Element.AUTHENTICATION);
            connector.authentication().attributes().write(writer);
            writer.writeEndElement();
        }
        connector.cors().write(writer);
        connector.encryption().write(writer);
        writer.writeEndElement();
    }

    private void writeConnector(ConfigurationWriter writer, MemcachedServerConfiguration connector) {
        if (connector.isImplicit()) {
            return;
        }
        connector.write(writer);
    }

    private void writeConnector(ConfigurationWriter writer, RespServerConfiguration connector) {
        if (connector.isImplicit()) {
            return;
        }
        connector.write(writer);
    }

    public static class CredentialSerializer
    implements AttributeSerializer<Supplier<CredentialSource>> {
        public void serialize(ConfigurationWriter writer, String name, Supplier<CredentialSource> value) {
            if (value instanceof PasswordCredentialSource) {
                String credential = writer.clearTextSecrets() ? new String(CredentialStoresConfiguration.resolvePassword(value)) : "***";
                writer.writeAttribute(name, credential);
            } else if (value instanceof CredentialStoresConfigurationBuilder.CredentialStoreSourceSupplier) {
                CredentialStoresConfigurationBuilder.CredentialStoreSourceSupplier credentialSupplier = (CredentialStoresConfigurationBuilder.CredentialStoreSourceSupplier)value;
                writer.writeStartElement((Enum)org.infinispan.server.configuration.Element.CREDENTIAL_REFERENCE);
                writer.writeAttribute((Enum)Attribute.STORE, credentialSupplier.getStore());
                writer.writeAttribute((Enum)Attribute.ALIAS, credentialSupplier.getAlias());
                writer.writeEndElement();
            } else {
                throw new IllegalArgumentException();
            }
        }

        public boolean defer() {
            return true;
        }
    }

    public static class CredentialProxySerializer
    implements AttributeSerializer<Supplier<CredentialSource>> {
        public void serialize(ConfigurationWriter writer, String name, Supplier<CredentialSource> value) {
            ((AttributeSerializer)value).serialize(writer, name, null);
        }

        public boolean defer() {
            return true;
        }
    }
}

