/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.AuthenticationConfiguration;
import org.infinispan.server.core.configuration.SaslConfiguration;

public class SaslAuthenticationConfiguration
implements AuthenticationConfiguration {
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).build();
    private final AttributeSet attributes;
    private final boolean enabled;
    private final SaslConfiguration saslConfiguration;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SaslAuthenticationConfiguration.class, new AttributeDefinition[]{SECURITY_REALM});
    }

    SaslAuthenticationConfiguration(AttributeSet attributes, SaslConfiguration saslConfiguration, boolean enabled) {
        this.attributes = attributes.checkProtection();
        this.saslConfiguration = saslConfiguration;
        this.enabled = enabled;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    @Override
    public String securityRealm() {
        return (String)this.attributes.attribute(SECURITY_REALM).get();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    public SaslConfiguration sasl() {
        return this.saslConfiguration;
    }

    public String toString() {
        return "AuthenticationConfiguration{attributes=" + String.valueOf(this.attributes) + ", enabled=" + this.enabled + ", sasl=" + String.valueOf((Object)this.saslConfiguration) + "}";
    }
}

