/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.infinispan.CacheException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.io.ExpandableMarshalledValueByteStream;
import org.infinispan.io.ImmutableMarshalledValueByteStream;
import org.infinispan.io.MarshalledValueByteStream;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.jboss.ExtendedRiverUnmarshaller;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.Util;

public class MarshalledValue
implements Serializable {
    protected volatile Object instance;
    protected volatile MarshalledValueByteStream raw;
    protected volatile int serialisedSize = 128;
    private volatile int cachedHashCode = 0;
    private volatile transient boolean equalityPreferenceForInstance = true;
    private final transient StreamingMarshaller marshaller;

    public MarshalledValue(Object instance, boolean equalityPreferenceForInstance, StreamingMarshaller marshaller) {
        if (instance == null) {
            throw new NullPointerException("Null values cannot be wrapped as MarshalledValues!");
        }
        this.instance = instance;
        this.equalityPreferenceForInstance = equalityPreferenceForInstance;
        this.marshaller = marshaller;
    }

    private MarshalledValue(byte[] raw, int cachedHashCode, StreamingMarshaller marshaller) {
        this.init(raw, cachedHashCode);
        this.marshaller = marshaller;
    }

    private void init(byte[] raw, int cachedHashCode) {
        this.raw = new ImmutableMarshalledValueByteStream(raw);
        this.serialisedSize = raw.length;
        this.cachedHashCode = cachedHashCode;
    }

    public synchronized MarshalledValueByteStream serialize() {
        return this.serialize0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshalledValueByteStream serialize0() {
        MarshalledValueByteStream localRaw = this.raw;
        if (localRaw == null) {
            try {
                ExpandableMarshalledValueByteStream baos = new ExpandableMarshalledValueByteStream(this.serialisedSize);
                ObjectOutput out = this.marshaller.startObjectOutput(baos, true, this.serialisedSize);
                try {
                    this.marshaller.objectToObjectStream(this.instance, out);
                }
                finally {
                    this.marshaller.finishObjectOutput(out);
                }
                this.serialisedSize = ((MarshalledValueByteStream)baos).size();
                localRaw = baos;
                this.raw = baos;
            }
            catch (Exception e) {
                throw new CacheException("Unable to marshall value " + this.instance, e);
            }
        }
        return localRaw;
    }

    public synchronized Object deserialize() {
        return this.deserialize0();
    }

    private Object deserialize0() {
        Object instanceValue = this.instance;
        if (instanceValue == null) {
            try {
                this.instance = instanceValue = this.marshaller.objectFromByteBuffer(this.raw.getRaw(), 0, this.raw.size());
                return instanceValue;
            }
            catch (Exception e) {
                throw new CacheException("Unable to unmarshall value", e);
            }
        }
        return instanceValue;
    }

    public synchronized void compact(boolean preferSerializedRepresentation, boolean force) {
        this.equalityPreferenceForInstance = true;
        Object thisInstance = this.instance;
        MarshalledValueByteStream thisRaw = this.raw;
        if (force) {
            if (preferSerializedRepresentation && thisRaw == null) {
                thisRaw = this.serialize0();
            } else if (!preferSerializedRepresentation && thisInstance == null) {
                thisInstance = this.deserialize0();
            }
        }
        if (thisInstance != null && thisRaw != null) {
            if (preferSerializedRepresentation) {
                this.raw = thisRaw;
                this.instance = null;
            } else {
                this.instance = thisInstance;
                this.raw = null;
            }
        }
    }

    public MarshalledValueByteStream getRaw() {
        MarshalledValueByteStream rawValue = this.raw;
        if (rawValue == null) {
            rawValue = this.serialize();
        }
        return rawValue;
    }

    public Object get() {
        Object value = this.instance;
        if (value == null) {
            value = this.deserialize();
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarshalledValue that = (MarshalledValue)o;
        boolean preferInstanceEquality = this.equalityPreferenceForInstance && that.equalityPreferenceForInstance;
        Object thisInstance = this.instance;
        Object thatInstance = that.instance;
        if (preferInstanceEquality && thisInstance != null && thatInstance != null) {
            return thisInstance.equals(thatInstance);
        }
        MarshalledValueByteStream thisRaw = this.raw;
        MarshalledValueByteStream thatRaw = that.raw;
        if (thisRaw != null && thatRaw != null) {
            return this.raw.equals(that.raw);
        }
        if (thisInstance != null && thatInstance != null) {
            return thisInstance.equals(thatInstance);
        }
        if (preferInstanceEquality) {
            if (thisInstance == null) {
                thisInstance = this.deserialize();
            }
            if (thatInstance == null) {
                thatInstance = that.deserialize();
            }
            return thisInstance.equals(thatInstance);
        }
        if (thisRaw == null) {
            thisRaw = this.serialize();
        }
        if (thatRaw == null) {
            thatRaw = that.serialize();
        }
        return Arrays.equals(thisRaw.getRaw(), thatRaw.getRaw());
    }

    public int hashCode() {
        int value = this.cachedHashCode;
        if (value == 0) {
            Object localInstance = this.deserialize();
            value = localInstance.hashCode();
            if (value == 0) {
                value = 65261;
            }
            this.cachedHashCode = value;
        }
        return value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("MarshalledValue{").append("instance=").append(this.instance != null ? this.instance.toString() : "<serialized>").append(", serialized=").append(this.raw != null ? Util.printArray(this.raw == null ? Util.EMPTY_BYTE_ARRAY : this.raw.getRaw(), false) : "false").append(", cachedHashCode=").append(this.cachedHashCode).append("}@").append(Util.hexIdHashCode(this));
        return sb.toString();
    }

    public MarshalledValue setEqualityPreferenceForInstance(boolean equalityPreferenceForInstance) {
        this.equalityPreferenceForInstance = equalityPreferenceForInstance;
        return this;
    }

    public static boolean isTypeExcluded(Class<?> type) {
        return type.equals(String.class) || type.isPrimitive() || type.equals(Void.class) || type.equals(Boolean.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.isArray() && MarshalledValue.isTypeExcluded(type.getComponentType()) || type.equals(GlobalTransaction.class) || Address.class.isAssignableFrom(type) || ReplicableCommand.class.isAssignableFrom(type) || type.equals(MarshalledValue.class);
    }

    public static class Externalizer
    extends AbstractExternalizer<MarshalledValue> {
        private final StreamingMarshaller globalMarshaller;

        public Externalizer(StreamingMarshaller globalMarshaller) {
            this.globalMarshaller = globalMarshaller;
        }

        @Override
        public void writeObject(ObjectOutput output, MarshalledValue mv) throws IOException {
            MarshalledValueByteStream raw = mv.getRaw();
            int rawLength = raw.size();
            UnsignedNumeric.writeUnsignedInt(output, rawLength);
            output.write(raw.getRaw(), 0, rawLength);
            output.writeInt(mv.hashCode());
        }

        @Override
        public MarshalledValue readObject(ObjectInput input) throws IOException {
            StreamingMarshaller ispnMarshaller;
            int length = UnsignedNumeric.readUnsignedInt(input);
            byte[] raw = new byte[length];
            input.readFully(raw);
            int hc = input.readInt();
            StreamingMarshaller marshaller = input instanceof ExtendedRiverUnmarshaller ? ((ispnMarshaller = ((ExtendedRiverUnmarshaller)((Object)input)).getInfinispanMarshaller()) != null ? ispnMarshaller : this.globalMarshaller) : this.globalMarshaller;
            return new MarshalledValue(raw, hc, marshaller);
        }

        @Override
        public Integer getId() {
            return 40;
        }

        @Override
        public Set<Class<? extends MarshalledValue>> getTypeClasses() {
            return Util.asSet(MarshalledValue.class);
        }
    }
}

