/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.Use1PcForInducedTransactionTest")
public class Use1PcForInducedTransactionTest
extends MultipleCacheManagersTest {
    private InvocationCountInterceptor ic0;
    private InvocationCountInterceptor ic1;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = Use1PcForInducedTransactionTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        c.transaction().use1PcForAutoCommitTransactions(true);
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.ic0 = new InvocationCountInterceptor();
        TestingUtil.extractInterceptorChain(this.cache(0)).addInterceptor((AsyncInterceptor)this.ic0, 1);
        this.ic1 = new InvocationCountInterceptor();
        TestingUtil.extractInterceptorChain(this.cache(1)).addInterceptor((AsyncInterceptor)this.ic1, 1);
    }

    public void testSinglePhaseCommit() {
        this.cache(0).put((Object)"k", (Object)"v");
        assert (this.cache(0).get((Object)"k").equals("v"));
        assert (this.cache(1).get((Object)"k").equals("v"));
        this.assertNotLocked("k");
        Assert.assertEquals((int)this.ic0.prepareInvocations, (int)1);
        Assert.assertEquals((int)this.ic1.prepareInvocations, (int)1);
        Assert.assertEquals((int)this.ic0.commitInvocations, (int)0);
        Assert.assertEquals((int)this.ic0.commitInvocations, (int)0);
    }

    public static class InvocationCountInterceptor
    extends DDAsyncInterceptor {
        volatile int prepareInvocations;
        volatile int commitInvocations;

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            ++this.prepareInvocations;
            return super.visitPrepareCommand(ctx, command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            ++this.commitInvocations;
            return super.visitCommitCommand(ctx, command);
        }
    }
}

