/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock.pessimistic;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lock.singlelock.AbstractLockOwnerCrashTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.pessimistic.LockOwnerCrashPessimisticTest")
@CleanupAfterMethod
public class LockOwnerCrashPessimisticTest
extends AbstractLockOwnerCrashTest {
    public LockOwnerCrashPessimisticTest() {
        super(CacheMode.DIST_SYNC, LockingMode.PESSIMISTIC, false);
    }

    public void testLockOwnerCrashesBeforePrepare() throws Exception {
        Object k = this.getKeyForCache(2);
        this.inNewThread(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
            }
            catch (Throwable e) {
                log.errorf(e, "Error starting transaction for key %s", k);
            }
        });
        LockOwnerCrashPessimisticTest.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        LockOwnerCrashPessimisticTest.eventually(() -> !this.checkLocked(0, k) && !this.checkLocked(1, k) && this.checkLocked(2, k));
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0).get(k));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k));
        this.assertNotLocked(k);
        LockOwnerCrashPessimisticTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
    }

    public void testLockOwnerCrashesBeforePrepareAndLockIsStillHeld() throws Exception {
        Object k = this.getKeyForCache(2);
        this.inNewThread(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
            }
            catch (Throwable e) {
                log.errorf(e, "Error starting transaction for key %s", k);
            }
        });
        LockOwnerCrashPessimisticTest.eventually(() -> !this.checkLocked(0, k) && !this.checkLocked(1, k) && this.checkLocked(2, k));
        this.killMember(2);
        assert (this.caches().size() == 2);
        this.tm(0).begin();
        try {
            this.cache(0).put(k, (Object)"v1");
            assert (false);
        }
        catch (Exception e) {
            this.tm(0).rollback();
        }
        this.tm(1).resume((Transaction)this.transaction);
        this.tm(1).commit();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0).get(k));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k));
        this.assertNotLocked(k);
        LockOwnerCrashPessimisticTest.eventually(() -> this.checkTxCount(0, 0, 0) && this.checkTxCount(1, 0, 0));
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit1() throws Exception {
        this.testCrashBeforeCommit(true);
    }

    public void lockOwnerCrasherBetweenPrepareAndCommit2() throws Exception {
        this.testCrashBeforeCommit(false);
    }

    private void testCrashBeforeCommit(boolean crashBeforePrepare) throws NotSupportedException, SystemException, InvalidTransactionException, HeuristicMixedException, RollbackException, HeuristicRollbackException {
        Object k = this.getKeyForCache(2);
        this.inNewThread(() -> {
            try {
                this.tm(1).begin();
                this.cache(1).put(k, (Object)"v");
                this.transaction = (EmbeddedTransaction)this.tm(1).getTransaction();
                if (!crashBeforePrepare) {
                    this.transaction.runPrepare();
                }
            }
            catch (Throwable e) {
                log.errorf(e, "Error preparing transaction for key %s", k);
            }
        });
        LockOwnerCrashPessimisticTest.eventually(() -> this.checkTxCount(0, 0, 1) && this.checkTxCount(1, 1, 0) && this.checkTxCount(2, 0, 1));
        LockOwnerCrashPessimisticTest.eventually(() -> !this.checkLocked(0, k) && !this.checkLocked(1, k) && this.checkLocked(2, k));
        this.killMember(2);
        AssertJUnit.assertEquals((int)2, (int)this.caches().size());
        this.tm(1).begin();
        try {
            this.cache(1).put(k, (Object)"v2");
            AssertJUnit.fail((String)("Exception expected as lock cannot be acquired on k=" + String.valueOf(k)));
        }
        catch (Exception e) {
            this.tm(1).rollback();
        }
        this.tm(0).begin();
        try {
            this.cache(0).put(k, (Object)"v3");
            AssertJUnit.fail((String)("Exception expected as lock cannot be acquired on k=" + String.valueOf(k)));
        }
        catch (Exception e) {
            this.tm(0).rollback();
        }
        this.tm(1).resume((Transaction)this.transaction);
        if (!crashBeforePrepare) {
            this.transaction.runCommit(false);
        } else {
            this.tm(1).commit();
        }
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0).get(k));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k));
        this.assertNotLocked(k);
    }
}

