/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.LocalRecoveryTest")
public class LocalRecoveryTest
extends SingleCacheManagerTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.jmx().enabled(true).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(false).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).recovery().enable();
        return TestCacheManagerFactory.createCacheManager(gcb, cb);
    }

    public void testRecoveryManagerInJmx() {
        AssertJUnit.assertTrue((boolean)this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional());
        String jmxDomain = this.cacheManager.getCacheManagerConfiguration().jmx().domain();
        ObjectName recoveryManager = TestingUtil.getCacheObjectName(jmxDomain, this.cache.getName() + "(local)", "RecoveryManager");
        AssertJUnit.assertFalse((boolean)this.mBeanServerLookup.getMBeanServer().isRegistered(recoveryManager));
    }

    public void testOneTx() throws Exception {
        this.embeddedTm().begin();
        this.cache.put((Object)"k", (Object)"v");
        TransactionXaAdapter xaRes = (TransactionXaAdapter)this.embeddedTm().firstEnlistedResource();
        RecoveryTestUtil.assertPrepared(0, this.embeddedTm().getTransaction());
        xaRes.prepare((Xid)xaRes.getLocalTransaction().getXid());
        RecoveryTestUtil.assertPrepared(1, this.embeddedTm().getTransaction());
        EmbeddedTransaction suspend = (EmbeddedTransaction)this.embeddedTm().suspend();
        xaRes.commit((Xid)xaRes.getLocalTransaction().getXid(), false);
        RecoveryTestUtil.assertPrepared(0, suspend);
        Assert.assertEquals((int)0, (int)TestingUtil.getTransactionTable(this.cache).getLocalTxCount());
    }

    public void testMultipleTransactions() throws Exception {
        EmbeddedTransaction suspend1 = this.beginTx();
        EmbeddedTransaction suspend2 = this.beginTx();
        EmbeddedTransaction suspend3 = this.beginTx();
        EmbeddedTransaction suspend4 = this.beginTx();
        RecoveryTestUtil.assertPrepared(0, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend1);
        RecoveryTestUtil.assertPrepared(1, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend2);
        RecoveryTestUtil.assertPrepared(2, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend3);
        RecoveryTestUtil.assertPrepared(3, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.prepareTransaction(suspend4);
        RecoveryTestUtil.assertPrepared(4, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend1);
        RecoveryTestUtil.assertPrepared(3, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend2);
        RecoveryTestUtil.assertPrepared(2, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend3);
        RecoveryTestUtil.assertPrepared(1, suspend1, suspend2, suspend3, suspend4);
        RecoveryTestUtil.commitTransaction(suspend4);
        RecoveryTestUtil.assertPrepared(0, suspend1, suspend2, suspend3, suspend4);
        Assert.assertEquals((int)0, (int)TestingUtil.getTransactionTable(this.cache).getLocalTxCount());
    }

    private EmbeddedTransaction beginTx() {
        return RecoveryTestUtil.beginAndSuspendTx(this.cache);
    }

    private EmbeddedTransactionManager embeddedTm() {
        return (EmbeddedTransactionManager)this.tm();
    }
}

