/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.FailureDuringPrepareTest")
@CleanupAfterMethod
public class FailureDuringPrepareTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = FailureDuringPrepareTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        c.clustering().hash().numOwners(3);
        this.createCluster(c, 3);
        this.waitForClusterToForm();
    }

    public void testResourceCleanedIfPrepareFails() throws Exception {
        this.runTest(false);
    }

    public void testResourceCleanedIfPrepareFails2() throws Exception {
        this.runTest(true);
    }

    private void runTest(boolean multipleResources) throws NotSupportedException, SystemException, RollbackException {
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)new FailInterceptor(), 2);
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        if (multipleResources) {
            this.tm(0).getTransaction().enlistResource((XAResource)new XAResourceAdapter());
        }
        Assert.assertEquals((int)this.lockManager(0).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(1).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(2).getNumberOfLocksHeld(), (int)0);
        try {
            this.tm(0).commit();
            assert (false);
        }
        catch (Exception e) {
            log.debug((Object)"Ignoring expected exception during prepare", (Throwable)e);
        }
        Assert.assertEquals((int)this.lockManager(0).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(1).getNumberOfLocksHeld(), (int)0);
        Assert.assertEquals((int)this.lockManager(2).getNumberOfLocksHeld(), (int)0);
    }

    static class FailInterceptor
    extends DDAsyncInterceptor {
        FailInterceptor() {
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            return this.invokeNextAndFinally((InvocationContext)ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> {
                throw new RuntimeException("Induced fault!");
            });
        }
    }
}

