/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.WriteSkewHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="container.versioning.VersionedDistStateTransferTest", groups={"functional"})
@CleanupAfterMethod
public class VersionedDistStateTransferTest
extends MultipleCacheManagersTest {
    ConfigurationBuilder builder;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        this.builder.clustering().cacheMode(CacheMode.DIST_SYNC).l1().disable().locking().isolationLevel(IsolationLevel.REPEATABLE_READ).transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.createCluster(TestDataSCI.INSTANCE, this.builder, 4);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        int i;
        int cacheIndex;
        Cache cache0 = this.cache(0);
        Cache cache3 = this.cache(3);
        int NUM_KEYS = 20;
        MagicKey[] keys = new MagicKey[NUM_KEYS];
        String[] values = new String[NUM_KEYS];
        for (int i2 = 0; i2 < NUM_KEYS; ++i2) {
            keys[i2] = new MagicKey("key" + i2, cache3);
            values[i2] = "v" + i2;
            cache0.put((Object)keys[i2], (Object)values[i2]);
        }
        this.checkStateTransfer(keys, values);
        Transaction[] txs = new Transaction[NUM_KEYS];
        for (int i3 = 0; i3 < NUM_KEYS; ++i3) {
            cacheIndex = i3 % 3;
            this.tm(cacheIndex).begin();
            AssertJUnit.assertEquals((Object)values[i3], (Object)this.cache(cacheIndex).get((Object)keys[i3]));
            txs[i3] = this.tm(cacheIndex).suspend();
        }
        log.debugf("Starting joiner", new Object[0]);
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.builder);
        Cache cache4 = this.cache(4);
        log.debugf("Joiner started, checking transferred data", new Object[0]);
        this.checkStateTransfer(keys, values);
        log.debugf("Stopping cache %s", cache3);
        this.manager(3).stop();
        this.cacheManagers.remove(3);
        TestingUtil.waitForNoRebalance(this.caches());
        log.debugf("Leaver stopped, checking transferred data", new Object[0]);
        this.checkStateTransfer(keys, values);
        for (i = 0; i < NUM_KEYS; ++i) {
            cache4.put((Object)keys[i], (Object)("new " + values[i]));
        }
        for (i = 0; i < NUM_KEYS; ++i) {
            int cacheIndex2 = i % 3;
            log.tracef("Expecting a write skew failure for key %s on cache %s", (Object)keys[i], this.cache(cacheIndex2));
            this.tm(cacheIndex2).resume(txs[i]);
            this.cache(cacheIndex2).put((Object)keys[i], (Object)("new new " + values[i]));
            try {
                this.tm(cacheIndex2).commit();
                AssertJUnit.fail((String)"The write skew check should have failed!");
                continue;
            }
            catch (RollbackException rollbackException) {
                // empty catch block
            }
        }
        for (cacheIndex = 0; cacheIndex < 4; ++cacheIndex) {
            for (int i4 = 0; i4 < NUM_KEYS; ++i4) {
                AssertJUnit.assertEquals((String)("Wrong value found on cache " + String.valueOf(this.cache(cacheIndex))), (Object)("new " + values[i4]), (Object)this.cache(cacheIndex).get((Object)keys[i4]));
            }
        }
    }

    private void checkStateTransfer(MagicKey[] keys, String[] values) {
        for (Cache c : this.caches()) {
            for (int i = 0; i < keys.length; ++i) {
                AssertJUnit.assertEquals((String)("Wrong value found on cache " + String.valueOf(c)), (Object)values[i], (Object)c.get((Object)keys[i]));
                this.checkVersion(c, keys[i]);
            }
        }
    }

    private void checkVersion(Cache<Object, Object> c, MagicKey key) {
        LocalizedCacheTopology topology = c.getAdvancedCache().getDistributionManager().getCacheTopology();
        if (topology.isReadOwner((Object)key)) {
            InternalCacheEntry ice = c.getAdvancedCache().getDataContainer().peek((Object)key);
            AssertJUnit.assertNotNull((String)("Entry not found on owner cache " + String.valueOf(c)), (Object)ice);
            AssertJUnit.assertNotNull((String)("Version is null on owner cache " + String.valueOf(c)), (Object)WriteSkewHelper.versionFromEntry((CacheEntry)ice));
        }
    }
}

