/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRelocator
implements Relocator {
    private static final String TOKEN_DOLLAR = "$";
    private static final String ESCAPE_TOKEN_DOLLAR = "__DOLLAR__";
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final boolean rawString;

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes) {
        this(patt, shadedPattern, includes, excludes, false);
    }

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes, boolean rawString) {
        this.rawString = rawString;
        if (rawString) {
            this.pathPattern = patt;
            this.shadedPathPattern = shadedPattern;
            this.pattern = null;
            this.shadedPattern = null;
        } else {
            if (patt == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = patt.replace('/', '.');
                this.pathPattern = patt.replace('.', '/');
            }
            if (shadedPattern != null) {
                this.shadedPattern = shadedPattern.replace('/', '.');
                this.shadedPathPattern = shadedPattern.replace('.', '/');
            } else {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            }
        }
        this.includes = SimpleRelocator.normalizePatterns(includes);
        this.excludes = SimpleRelocator.normalizePatterns(excludes);
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = null;
        if (patterns != null && !patterns.isEmpty()) {
            normalized = new LinkedHashSet<String>();
            for (String pattern : patterns) {
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*")) continue;
                String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
                normalized.add(packagePattern);
            }
        }
        return normalized;
    }

    private boolean isIncluded(String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)path, (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!this.isIncluded(path) || this.isExcluded(path)) {
            return false;
        }
        return path.startsWith(this.pathPattern) || path.startsWith("/" + this.pathPattern);
    }

    @Override
    public boolean canRelocateClass(String clazz) {
        return !this.rawString && clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    private String unescapeRelocationResult(String escapedResult, String patternSubstitution, char pathSeparator) {
        int indexOfSeparator;
        String result = escapedResult.replace(ESCAPE_TOKEN_DOLLAR, TOKEN_DOLLAR);
        boolean endsWithDollar = patternSubstitution.endsWith(TOKEN_DOLLAR);
        if (endsWithDollar && (indexOfSeparator = result.lastIndexOf(pathSeparator)) > 0) {
            StringBuilder builder = new StringBuilder(result);
            builder.insert(indexOfSeparator + 1, TOKEN_DOLLAR);
            result = builder.toString();
        }
        return result;
    }

    private String escapeSubstitution(String pattern) {
        return pattern.replace(TOKEN_DOLLAR, ESCAPE_TOKEN_DOLLAR);
    }

    @Override
    public String relocatePath(String path) {
        try {
            if (this.rawString) {
                return this.unescapeRelocationResult(path.replaceAll(this.pathPattern, this.escapeSubstitution(this.shadedPathPattern)), this.shadedPathPattern, '/');
            }
            return this.unescapeRelocationResult(path.replaceFirst(this.pathPattern, this.escapeSubstitution(this.shadedPathPattern)), this.shadedPathPattern, '/');
        }
        catch (RuntimeException ex) {
            String message = "rawString= " + this.rawString;
            message = message + ", path=" + path;
            message = message + ", pathPattern=" + this.pathPattern;
            message = message + ", shadedPathPattern=" + this.shadedPathPattern;
            throw new RuntimeException(message, ex);
        }
    }

    @Override
    public String relocateClass(String clazz) {
        return this.unescapeRelocationResult(clazz.replaceFirst(this.pattern, this.escapeSubstitution(this.shadedPattern)), this.shadedPattern, '.');
    }

    @Override
    public String applyToSourceContent(String sourceContent) {
        if (this.rawString) {
            return sourceContent;
        }
        return sourceContent.replaceAll("\\b" + this.pattern, this.shadedPattern);
    }
}

