/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import jakarta.validation.ConstraintValidator;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.util.Collection;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintTree;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorContextImpl;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import org.hibernate.validator.internal.engine.constraintvalidation.ConstraintViolationCreationContext;
import org.hibernate.validator.internal.engine.validationcontext.ValidationContext;
import org.hibernate.validator.internal.engine.valuecontext.ValueContext;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

final class SimpleConstraintTree<B extends Annotation>
extends ConstraintTree<B> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    public SimpleConstraintTree(ConstraintValidatorManager constraintValidatorManager, ConstraintDescriptorImpl<B> descriptor, Type validatedValueType) {
        super(constraintValidatorManager, descriptor, validatedValueType);
    }

    @Override
    public boolean validateConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext) {
        ConstraintValidatorContextImpl constraintValidatorContext = this.doValidateConstraints(validationContext, valueContext);
        if (constraintValidatorContext != null) {
            for (ConstraintViolationCreationContext constraintViolationCreationContext : constraintValidatorContext.getConstraintViolationCreationContexts()) {
                validationContext.addConstraintFailure(valueContext, constraintViolationCreationContext, constraintValidatorContext.getConstraintDescriptor());
            }
            return false;
        }
        return true;
    }

    @Override
    protected void validateConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext, Collection<ConstraintValidatorContextImpl> violatedConstraintValidatorContexts) {
        ConstraintValidatorContextImpl constraintValidatorContext = this.doValidateConstraints(validationContext, valueContext);
        if (constraintValidatorContext != null) {
            violatedConstraintValidatorContexts.add(constraintValidatorContext);
        }
    }

    private ConstraintValidatorContextImpl doValidateConstraints(ValidationContext<?> validationContext, ValueContext<?, ?> valueContext) {
        if (LOG.isTraceEnabled()) {
            if (validationContext.isShowValidatedValuesInTraceLogs()) {
                LOG.tracef("Validating value %s against constraint defined by %s.", valueContext.getCurrentValidatedValue(), this.descriptor);
            } else {
                LOG.tracef("Validating against constraint defined by %s.", this.descriptor);
            }
        }
        ConstraintValidator validator = this.getInitializedConstraintValidator(validationContext, valueContext);
        ConstraintValidatorContextImpl constraintValidatorContext = validationContext.createConstraintValidatorContextFor(this.descriptor, valueContext.getPropertyPath());
        return this.validateSingleConstraint(valueContext, constraintValidatorContext, validator);
    }
}

