/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.spi.PojoIndexingProcessorSessionContext;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorCastedTypeNode<T, U>
extends PojoIndexingProcessor<T> {
    private final PojoCaster<U> caster;
    private final Iterable<IndexObjectFieldReference> parentIndexObjectReferences;
    private final PojoIndexingProcessor<? super U> nested;

    public PojoIndexingProcessorCastedTypeNode(PojoCaster<U> caster, Iterable<IndexObjectFieldReference> parentIndexObjectReferences, PojoIndexingProcessor<? super U> nested) {
        this.caster = caster;
        this.parentIndexObjectReferences = parentIndexObjectReferences;
        this.nested = nested;
    }

    @Override
    public void close() {
        this.nested.close();
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("operation", (Object)"process type (with cast)");
        builder.attribute("caster", this.caster);
        builder.attribute("objectFieldsToCreate", this.parentIndexObjectReferences);
        builder.attribute("nested", this.nested);
    }

    @Override
    public final void process(DocumentElement target, T source, PojoIndexingProcessorSessionContext sessionContext) {
        if (source == null) {
            return;
        }
        U castedSource = this.caster.cast(sessionContext.runtimeIntrospector().unproxy(source));
        DocumentElement parentObject = target;
        for (IndexObjectFieldReference objectFieldReference : this.parentIndexObjectReferences) {
            parentObject = parentObject.addObject(objectFieldReference);
        }
        this.nested.process(parentObject, castedSource, sessionContext);
    }
}

