/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.typepattern.impl;

import java.lang.reflect.TypeVariable;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.typepattern.impl.ExtractingTypePatternMatcher;

class ParameterizedTypeArgumentMatcher
implements ExtractingTypePatternMatcher {
    private final Class<?> matchedRawType;
    private final int resultTypeParameterIndex;

    ParameterizedTypeArgumentMatcher(Class<?> matchedRawType, int resultTypeParameterIndex) {
        this.matchedRawType = matchedRawType;
        this.resultTypeParameterIndex = resultTypeParameterIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.matchedRawType.getName()).append("<");
        TypeVariable<Class<?>>[] typeParameters = this.matchedRawType.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            if (i == this.resultTypeParameterIndex) {
                builder.append("T");
                continue;
            }
            builder.append("?");
        }
        builder.append(">").append(" => T");
        return builder.toString();
    }

    @Override
    public Optional<? extends PojoGenericTypeModel<?>> extract(PojoGenericTypeModel<?> typeToInspect) {
        return typeToInspect.typeArgument(this.matchedRawType, this.resultTypeParameterIndex);
    }
}

