/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.search.engine.tenancy.spi.TenancyMode;
import org.hibernate.search.mapper.orm.loading.impl.HibernateOrmMassLoadingContext;
import org.hibernate.search.mapper.orm.loading.spi.ConditionalExpression;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.tenancy.spi.TenancyConfiguration;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.MassIndexingDefaultCleanOperation;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;

public final class HibernateOrmMassIndexingContext
implements PojoMassIndexingContext,
HibernateOrmMassLoadingContext {
    private final HibernateOrmMassIndexingMappingContext mapping;
    private final Map<Class<?>, ConditionalExpression> conditionalExpressions = new HashMap();
    private final Set<String> actualTenantIds;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private Integer idLoadingTransactionTimeout;
    private int idFetchSize = 100;
    private int objectLoadingBatchSize = 10;
    private long objectsLimit = 0L;

    public HibernateOrmMassIndexingContext(HibernateOrmMassIndexingMappingContext mapping, Set<String> actualTenantIds) {
        this.mapping = mapping;
        this.actualTenantIds = actualTenantIds;
    }

    @Override
    public HibernateOrmMassIndexingMappingContext mapping() {
        return this.mapping;
    }

    public void idLoadingTransactionTimeout(int timeoutInSeconds) {
        this.idLoadingTransactionTimeout = timeoutInSeconds;
    }

    @Override
    public Integer idLoadingTransactionTimeout() {
        return this.idLoadingTransactionTimeout;
    }

    public void cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Override
    public CacheMode cacheMode() {
        return this.cacheMode;
    }

    public void objectLoadingBatchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be at least 1");
        }
        this.objectLoadingBatchSize = batchSize;
    }

    @Override
    public int objectLoadingBatchSize() {
        return this.objectLoadingBatchSize;
    }

    public void objectsLimit(long maximum) {
        this.objectsLimit = maximum;
    }

    @Override
    public long objectsLimit() {
        return this.objectsLimit;
    }

    public void idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
    }

    @Override
    public int idFetchSize() {
        return this.idFetchSize;
    }

    ConditionalExpression reindexOnly(Class<?> type, String conditionalExpression) {
        ConditionalExpression expression = new ConditionalExpression(conditionalExpression);
        this.conditionalExpressions.put(type, expression);
        return expression;
    }

    @Override
    public Optional<ConditionalExpression> conditionalExpression(PojoLoadingTypeContext<?> typeContext) {
        if (this.conditionalExpressions.isEmpty()) {
            return Optional.empty();
        }
        return typeContext.ascendingSuperTypes().stream().map(typeId -> this.conditionalExpressions.get(typeId.javaClass())).filter(Objects::nonNull).findFirst();
    }

    @Override
    public TenancyConfiguration tenancyConfiguration() {
        return this.mapping.tenancyConfiguration();
    }

    public Set<String> tenantIds() {
        return this.actualTenantIds;
    }

    public TenancyMode tenancyMode() {
        return this.mapping.tenancyConfiguration().tenancyMode();
    }

    public MassIndexingDefaultCleanOperation massIndexingDefaultCleanOperation() {
        return this.mapping.massIndexingDefaultCleanOperation();
    }
}

