/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class BatchTransactionalContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    final SessionFactoryImplementor factory;
    final TransactionManager transactionManager;
    final TransactionCoordinatorBuilder transactionCoordinatorBuilder;

    public BatchTransactionalContext(SessionFactoryImplementor sessionFactory) {
        this.factory = sessionFactory;
        this.transactionManager = BatchTransactionalContext.lookupTransactionManager(this.factory);
        this.transactionCoordinatorBuilder = BatchTransactionalContext.lookupTransactionCoordinatorBuilder(this.factory);
    }

    private static TransactionCoordinatorBuilder lookupTransactionCoordinatorBuilder(SessionFactoryImplementor sessionFactory) {
        return (TransactionCoordinatorBuilder)sessionFactory.getServiceRegistry().getService(TransactionCoordinatorBuilder.class);
    }

    private static TransactionManager lookupTransactionManager(SessionFactoryImplementor sessionFactory) {
        return ((JtaPlatform)sessionFactory.getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
    }

    boolean wrapInTransaction() {
        if (!this.transactionCoordinatorBuilder.isJta()) {
            log.trace("TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        if (this.transactionManager == null) {
            log.trace("No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (this.transactionManager.getStatus() == 6) {
                log.trace("No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace("Transaction in progress, no need to start a JTA transaction");
        return false;
    }
}

