/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.impl;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchIndexesContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentFieldValueConvertContextImpl;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContextImpl;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;

public final class LuceneSearchContext {
    private final ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext;
    private final ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext;
    private final LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final TimingSource timingSource;
    private final LuceneSearchIndexesContext indexes;

    public LuceneSearchContext(BackendMappingContext mappingContext, LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry, MultiTenancyStrategy multiTenancyStrategy, TimingSource timingSource, LuceneSearchIndexesContext indexes) {
        this.toDocumentIdentifierValueConvertContext = new ToDocumentIdentifierValueConvertContextImpl(mappingContext);
        this.toDocumentFieldValueConvertContext = new ToDocumentFieldValueConvertContextImpl(mappingContext);
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.timingSource = timingSource;
        this.indexes = indexes;
    }

    public ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext() {
        return this.toDocumentIdentifierValueConvertContext;
    }

    public ToDocumentFieldValueConvertContext toDocumentFieldValueConvertContext() {
        return this.toDocumentFieldValueConvertContext;
    }

    public LuceneAnalysisDefinitionRegistry analysisDefinitionRegistry() {
        return this.analysisDefinitionRegistry;
    }

    public LuceneSearchIndexesContext indexes() {
        return this.indexes;
    }

    public Query filterOrNull(String tenantId) {
        return this.multiTenancyStrategy.filterOrNull(tenantId);
    }

    public TimeoutManager createTimeoutManager(Long timeout, TimeUnit timeUnit, boolean exceptionOnTimeout) {
        return TimeoutManager.of((TimingSource)this.timingSource, (Long)timeout, (TimeUnit)timeUnit, (boolean)exceptionOnTimeout);
    }
}

