/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.descriptor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;
import org.hibernate.validator.internal.metadata.descriptor.ElementDescriptorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.method.metadata.MethodDescriptor;
import org.hibernate.validator.method.metadata.ParameterDescriptor;
import org.hibernate.validator.method.metadata.TypeDescriptor;

public class BeanDescriptorImpl<T>
extends ElementDescriptorImpl
implements BeanDescriptor,
TypeDescriptor {
    private final Map<String, PropertyDescriptor> constrainedProperties;
    private final Map<String, MethodDescriptor> methods;
    private final Set<MethodDescriptor> constrainedMethods;

    public BeanDescriptorImpl(Class<T> beanClass, Set<ConstraintDescriptorImpl<?>> classLevelConstraints, Map<String, PropertyDescriptor> properties, Map<String, MethodDescriptor> methods, boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        super(beanClass, classLevelConstraints, false, defaultGroupSequenceRedefined, defaultGroupSequence);
        this.constrainedProperties = Collections.unmodifiableMap(properties);
        this.methods = Collections.unmodifiableMap(methods);
        this.constrainedMethods = Collections.unmodifiableSet(this.getConstrainedMethods(methods.values()));
    }

    public final boolean isBeanConstrained() {
        return this.hasConstraints() || !this.constrainedProperties.isEmpty();
    }

    public final PropertyDescriptor getConstraintsForProperty(String propertyName) {
        Contracts.assertNotNull(propertyName, "The property name cannot be null");
        return this.constrainedProperties.get(propertyName);
    }

    public final Set<PropertyDescriptor> getConstrainedProperties() {
        return new HashSet<PropertyDescriptor>(this.constrainedProperties.values());
    }

    @Override
    public boolean isTypeConstrained() {
        return this.isBeanConstrained() || !this.constrainedMethods.isEmpty();
    }

    @Override
    public Set<MethodDescriptor> getConstrainedMethods() {
        return this.constrainedMethods;
    }

    @Override
    public MethodDescriptor getConstraintsForMethod(String methodName, Class<?> ... parameterTypes) {
        Contracts.assertNotNull(methodName, Messages.MESSAGES.methodNameMustNotBeNull());
        return this.methods.get(methodName + Arrays.toString(parameterTypes));
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this;
    }

    private Set<MethodDescriptor> getConstrainedMethods(Collection<MethodDescriptor> methods) {
        HashSet<MethodDescriptor> theValue = CollectionHelper.newHashSet();
        for (MethodDescriptor oneMethod : methods) {
            if (oneMethod.hasConstraints() || oneMethod.isCascaded()) {
                theValue.add(oneMethod);
            }
            for (ParameterDescriptor oneParameter : oneMethod.getParameterDescriptors()) {
                if (!oneParameter.hasConstraints() && !oneParameter.isCascaded()) continue;
                theValue.add(oneMethod);
            }
        }
        return theValue;
    }
}

