/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.hcore.impl;

import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class HibernateSearchIntegrator
implements Integrator {
    private static final Log log = LoggerFactory.make();
    public static final String AUTO_REGISTER = "hibernate.search.autoregister_listeners";
    private FullTextIndexEventListener listener;

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        boolean registerListeners = ConfigurationHelper.getBoolean((String)AUTO_REGISTER, (Map)configuration.getProperties(), (boolean)true);
        if (!registerListeners) {
            log.debug((Object)"Skipping Hibernate Search event listener auto registration");
            return;
        }
        this.listener = new FullTextIndexEventListener(FullTextIndexEventListener.Installation.SINGLE_INSTANCE);
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        listenerRegistry.addDuplicationStrategy((DuplicationStrategy)new DuplicationStrategyImpl(FullTextIndexEventListener.class));
        listenerRegistry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_RECREATE).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_REMOVE).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.POST_COLLECTION_UPDATE).appendListener((Object)this.listener);
        listenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)this.listener);
        this.listener.initialize(configuration);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.listener != null) {
            this.listener.cleanup();
        }
    }

    public static class DuplicationStrategyImpl
    implements DuplicationStrategy {
        private final Class checkClass;

        public DuplicationStrategyImpl(Class checkClass) {
            this.checkClass = checkClass;
        }

        public boolean areMatch(Object listener, Object original) {
            return this.checkClass == original.getClass() && this.checkClass == listener.getClass();
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }
}

