/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.nulls.codec.impl.NotEncodingCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

public class DocumentFieldMetadata {
    private final BackReference<TypeMetadata> sourceType;
    private final BackReference<PropertyMetadata> sourceProperty;
    private final DocumentFieldPath path;
    private final Store store;
    private final Field.Index index;
    private final Field.TermVector termVector;
    private final FieldBridge fieldBridge;
    private final Float boost;
    private final AnalyzerReference analyzerReference;
    private final boolean isId;
    private final boolean isIdInEmbedded;
    private final NullMarkerCodec nullMarkerCodec;
    private final boolean isNumeric;
    private final boolean isSpatial;
    private final int precisionStep;
    private final NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType;
    private final Set<FacetMetadata> facetMetadata;
    private final Map<String, BridgeDefinedField> bridgeDefinedFields;

    private DocumentFieldMetadata(Builder builder) {
        this.sourceType = builder.sourceType;
        this.sourceProperty = builder.sourceProperty;
        this.path = builder.path;
        this.store = builder.store;
        this.index = builder.index;
        this.termVector = builder.termVector;
        this.fieldBridge = builder.fieldBridge;
        this.boost = builder.boost;
        this.analyzerReference = builder.analyzerReference;
        this.isId = builder.isId;
        this.isIdInEmbedded = builder.isIdInEmbedded;
        this.nullMarkerCodec = builder.nullMarkerCodec;
        this.isNumeric = builder.isNumeric;
        this.isSpatial = builder.isSpatial;
        this.precisionStep = builder.precisionStep;
        this.numericEncodingType = builder.numericEncodingType;
        this.facetMetadata = Collections.unmodifiableSet(builder.facetMetadata);
        this.bridgeDefinedFields = Collections.unmodifiableMap(builder.bridgeDefinedFields);
    }

    public TypeMetadata getSourceType() {
        return this.sourceType.get();
    }

    public PropertyMetadata getSourceProperty() {
        return this.sourceProperty.get();
    }

    public String getAbsoluteName() {
        return this.path.getAbsoluteName();
    }

    public DocumentFieldPath getPath() {
        return this.path;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isIdInEmbedded() {
        return this.isIdInEmbedded;
    }

    public Store getStore() {
        return this.store;
    }

    public Field.Index getIndex() {
        return this.index;
    }

    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    public FieldBridge getFieldBridge() {
        return this.fieldBridge;
    }

    public Float getBoost() {
        return this.boost;
    }

    public AnalyzerReference getAnalyzerReference() {
        return this.analyzerReference;
    }

    public NullMarkerCodec getNullMarkerCodec() {
        return this.nullMarkerCodec;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public boolean isSpatial() {
        return this.isSpatial;
    }

    public Integer getPrecisionStep() {
        return this.precisionStep;
    }

    public NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType() {
        return this.numericEncodingType;
    }

    public boolean hasFacets() {
        return !this.facetMetadata.isEmpty();
    }

    public Set<FacetMetadata> getFacetMetadata() {
        return this.facetMetadata;
    }

    public Map<String, BridgeDefinedField> getBridgeDefinedFields() {
        return this.bridgeDefinedFields;
    }

    public String toString() {
        return "DocumentFieldMetadata{path='" + this.path + '\'' + ", sourceType='" + this.sourceType + '\'' + ", sourceProperty='" + this.sourceProperty + '\'' + ", store=" + (Object)((Object)this.store) + ", index=" + this.index + ", termVector=" + this.termVector + ", fieldBridge=" + this.fieldBridge + ", boost=" + this.boost + ", analyzer=" + this.analyzerReference + ", isId=" + this.isId + ", isIdInEmbedded=" + this.isIdInEmbedded + ", nullMarkerCodec='" + this.nullMarkerCodec + '\'' + ", isNumeric=" + this.isNumeric + ", isSpatial=" + this.isSpatial + ", precisionStep=" + this.precisionStep + ", numericEncodingType=" + (Object)((Object)this.numericEncodingType) + ", facetMetadata=" + this.facetMetadata + '}';
    }

    public static class Builder {
        protected final BackReference<DocumentFieldMetadata> resultReference = new BackReference();
        private final BackReference<TypeMetadata> sourceType;
        private final BackReference<PropertyMetadata> sourceProperty;
        private final DocumentFieldPath path;
        private final Store store;
        private final Field.Index index;
        private final Field.TermVector termVector;
        private FieldBridge fieldBridge;
        private Float boost;
        private AnalyzerReference analyzerReference;
        private boolean isId;
        private boolean isIdInEmbedded;
        private boolean isNumeric;
        private boolean isSpatial;
        private int precisionStep = 4;
        private NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType;
        private Set<FacetMetadata> facetMetadata;
        private NullMarkerCodec nullMarkerCodec = NotEncodingCodec.SINGLETON;
        private final Map<String, BridgeDefinedField> bridgeDefinedFields;

        public Builder(BackReference<TypeMetadata> sourceType, BackReference<PropertyMetadata> sourceProperty, DocumentFieldPath path, Store store, Field.Index index, Field.TermVector termVector) {
            this.sourceType = sourceType;
            this.sourceProperty = sourceProperty;
            this.path = path;
            this.store = store;
            this.index = index;
            this.termVector = termVector;
            this.facetMetadata = new LinkedHashSet<FacetMetadata>(1);
            this.bridgeDefinedFields = new LinkedHashMap<String, BridgeDefinedField>();
        }

        public String getAbsoluteName() {
            return this.path.getAbsoluteName();
        }

        public String getRelativeName() {
            return this.path.getRelativeName();
        }

        public Builder fieldBridge(FieldBridge fieldBridge) {
            this.fieldBridge = fieldBridge;
            return this;
        }

        public Builder boost(Float boost) {
            this.boost = boost;
            return this;
        }

        public Builder analyzerReference(AnalyzerReference analyzerReference) {
            this.analyzerReference = analyzerReference;
            return this;
        }

        public Builder id() {
            this.isId = true;
            return this;
        }

        public Builder idInEmbedded() {
            this.isIdInEmbedded = true;
            return this;
        }

        public Builder indexNullAs(NullMarkerCodec nullMarkerCodec) {
            this.nullMarkerCodec = nullMarkerCodec;
            return this;
        }

        public Builder numeric() {
            this.isNumeric = true;
            return this;
        }

        public Builder spatial() {
            this.isSpatial = true;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder numericEncodingType(NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType) {
            this.numericEncodingType = numericEncodingType;
            return this;
        }

        public Builder addFacetMetadata(FacetMetadata facetMetadata) {
            this.facetMetadata.add(facetMetadata);
            return this;
        }

        public Builder addBridgeDefinedField(BridgeDefinedField bridgeDefinedField) {
            this.bridgeDefinedFields.put(bridgeDefinedField.getAbsoluteName(), bridgeDefinedField);
            return this;
        }

        public BackReference<DocumentFieldMetadata> getResultReference() {
            return this.resultReference;
        }

        public DocumentFieldMetadata build() {
            DocumentFieldMetadata result = new DocumentFieldMetadata(this);
            this.resultReference.initialize(result);
            return result;
        }

        public String toString() {
            return "Builder{path='" + this.path + '\'' + '}';
        }
    }
}

